package zio.aws.iam.model
import zio.aws.iam.model.primitives.{ResponseMarkerType, BooleanType}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListGroupsForUserResponse(
    groups: Iterable[zio.aws.iam.model.Group],
    isTruncated: Optional[BooleanType] = Optional.Absent,
    marker: Optional[ResponseMarkerType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iam.model.ListGroupsForUserResponse = {
    import ListGroupsForUserResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iam.model.ListGroupsForUserResponse
      .builder()
      .groups(groups.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        isTruncated.map(value => BooleanType.unwrap(value): java.lang.Boolean)
      )(_.isTruncated)
      .optionallyWith(
        marker.map(value => ResponseMarkerType.unwrap(value): java.lang.String)
      )(_.marker)
      .build()
  }
  def asReadOnly: zio.aws.iam.model.ListGroupsForUserResponse.ReadOnly =
    zio.aws.iam.model.ListGroupsForUserResponse.wrap(buildAwsValue())
}
object ListGroupsForUserResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iam.model.ListGroupsForUserResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iam.model.ListGroupsForUserResponse =
      zio.aws.iam.model.ListGroupsForUserResponse(
        groups.map { item =>
          item.asEditable
        },
        isTruncated.map(value => value),
        marker.map(value => value)
      )
    def groups: List[zio.aws.iam.model.Group.ReadOnly]
    def isTruncated: Optional[BooleanType]
    def marker: Optional[ResponseMarkerType]
    def getGroups: ZIO[Any, Nothing, List[zio.aws.iam.model.Group.ReadOnly]] =
      ZIO.succeed(groups)
    def getIsTruncated: ZIO[Any, AwsError, BooleanType] =
      AwsError.unwrapOptionField("isTruncated", isTruncated)
    def getMarker: ZIO[Any, AwsError, ResponseMarkerType] =
      AwsError.unwrapOptionField("marker", marker)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iam.model.ListGroupsForUserResponse
  ) extends zio.aws.iam.model.ListGroupsForUserResponse.ReadOnly {
    override val groups: List[zio.aws.iam.model.Group.ReadOnly] = impl
      .groups()
      .asScala
      .map { item =>
        zio.aws.iam.model.Group.wrap(item)
      }
      .toList
    override val isTruncated: Optional[BooleanType] = zio.aws.core.internal
      .optionalFromNullable(impl.isTruncated())
      .map(value => zio.aws.iam.model.primitives.BooleanType(value))
    override val marker: Optional[ResponseMarkerType] = zio.aws.core.internal
      .optionalFromNullable(impl.marker())
      .map(value => zio.aws.iam.model.primitives.ResponseMarkerType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iam.model.ListGroupsForUserResponse
  ): zio.aws.iam.model.ListGroupsForUserResponse.ReadOnly = new Wrapper(impl)
}
