package zio.aws.iam.model
import zio.aws.iam.model.primitives.{ResponseMarkerType, BooleanType}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListPoliciesGrantingServiceAccessResponse(
    policiesGrantingServiceAccess: Iterable[
      zio.aws.iam.model.ListPoliciesGrantingServiceAccessEntry
    ],
    isTruncated: Optional[BooleanType] = Optional.Absent,
    marker: Optional[ResponseMarkerType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iam.model.ListPoliciesGrantingServiceAccessResponse = {
    import ListPoliciesGrantingServiceAccessResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iam.model.ListPoliciesGrantingServiceAccessResponse
      .builder()
      .policiesGrantingServiceAccess(policiesGrantingServiceAccess.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        isTruncated.map(value => BooleanType.unwrap(value): java.lang.Boolean)
      )(_.isTruncated)
      .optionallyWith(
        marker.map(value => ResponseMarkerType.unwrap(value): java.lang.String)
      )(_.marker)
      .build()
  }
  def asReadOnly
      : zio.aws.iam.model.ListPoliciesGrantingServiceAccessResponse.ReadOnly =
    zio.aws.iam.model.ListPoliciesGrantingServiceAccessResponse
      .wrap(buildAwsValue())
}
object ListPoliciesGrantingServiceAccessResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iam.model.ListPoliciesGrantingServiceAccessResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.iam.model.ListPoliciesGrantingServiceAccessResponse =
      zio.aws.iam.model.ListPoliciesGrantingServiceAccessResponse(
        policiesGrantingServiceAccess.map { item =>
          item.asEditable
        },
        isTruncated.map(value => value),
        marker.map(value => value)
      )
    def policiesGrantingServiceAccess: List[
      zio.aws.iam.model.ListPoliciesGrantingServiceAccessEntry.ReadOnly
    ]
    def isTruncated: Optional[BooleanType]
    def marker: Optional[ResponseMarkerType]
    def getPoliciesGrantingServiceAccess: ZIO[Any, Nothing, List[
      zio.aws.iam.model.ListPoliciesGrantingServiceAccessEntry.ReadOnly
    ]] = ZIO.succeed(policiesGrantingServiceAccess)
    def getIsTruncated: ZIO[Any, AwsError, BooleanType] =
      AwsError.unwrapOptionField("isTruncated", isTruncated)
    def getMarker: ZIO[Any, AwsError, ResponseMarkerType] =
      AwsError.unwrapOptionField("marker", marker)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iam.model.ListPoliciesGrantingServiceAccessResponse
  ) extends zio.aws.iam.model.ListPoliciesGrantingServiceAccessResponse.ReadOnly {
    override val policiesGrantingServiceAccess: List[
      zio.aws.iam.model.ListPoliciesGrantingServiceAccessEntry.ReadOnly
    ] = impl
      .policiesGrantingServiceAccess()
      .asScala
      .map { item =>
        zio.aws.iam.model.ListPoliciesGrantingServiceAccessEntry.wrap(item)
      }
      .toList
    override val isTruncated: Optional[BooleanType] = zio.aws.core.internal
      .optionalFromNullable(impl.isTruncated())
      .map(value => zio.aws.iam.model.primitives.BooleanType(value))
    override val marker: Optional[ResponseMarkerType] = zio.aws.core.internal
      .optionalFromNullable(impl.marker())
      .map(value => zio.aws.iam.model.primitives.ResponseMarkerType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iam.model.ListPoliciesGrantingServiceAccessResponse
  ): zio.aws.iam.model.ListPoliciesGrantingServiceAccessResponse.ReadOnly =
    new Wrapper(impl)
}
