package zio.aws.iam.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListSamlProvidersResponse(
    samlProviderList: Optional[
      Iterable[zio.aws.iam.model.SAMLProviderListEntry]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iam.model.ListSamlProvidersResponse = {
    import ListSamlProvidersResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iam.model.ListSamlProvidersResponse
      .builder()
      .optionallyWith(
        samlProviderList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.samlProviderList)
      .build()
  }
  def asReadOnly: zio.aws.iam.model.ListSamlProvidersResponse.ReadOnly =
    zio.aws.iam.model.ListSamlProvidersResponse.wrap(buildAwsValue())
}
object ListSamlProvidersResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iam.model.ListSamlProvidersResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iam.model.ListSamlProvidersResponse =
      zio.aws.iam.model.ListSamlProvidersResponse(
        samlProviderList.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def samlProviderList
        : Optional[List[zio.aws.iam.model.SAMLProviderListEntry.ReadOnly]]
    def getSamlProviderList: ZIO[Any, AwsError, List[
      zio.aws.iam.model.SAMLProviderListEntry.ReadOnly
    ]] = AwsError.unwrapOptionField("samlProviderList", samlProviderList)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iam.model.ListSamlProvidersResponse
  ) extends zio.aws.iam.model.ListSamlProvidersResponse.ReadOnly {
    override val samlProviderList
        : Optional[List[zio.aws.iam.model.SAMLProviderListEntry.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.samlProviderList())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.iam.model.SAMLProviderListEntry.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iam.model.ListSamlProvidersResponse
  ): zio.aws.iam.model.ListSamlProvidersResponse.ReadOnly = new Wrapper(impl)
}
