package zio.aws.iam.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.iam.model.primitives.{
  MaxItemsType,
  MarkerType,
  ExistingUserNameType
}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListUserPoliciesRequest(
    userName: ExistingUserNameType,
    marker: Optional[MarkerType] = Optional.Absent,
    maxItems: Optional[MaxItemsType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iam.model.ListUserPoliciesRequest = {
    import ListUserPoliciesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iam.model.ListUserPoliciesRequest
      .builder()
      .userName(ExistingUserNameType.unwrap(userName): java.lang.String)
      .optionallyWith(
        marker.map(value => MarkerType.unwrap(value): java.lang.String)
      )(_.marker)
      .optionallyWith(
        maxItems.map(value => MaxItemsType.unwrap(value): Integer)
      )(_.maxItems)
      .build()
  }
  def asReadOnly: zio.aws.iam.model.ListUserPoliciesRequest.ReadOnly =
    zio.aws.iam.model.ListUserPoliciesRequest.wrap(buildAwsValue())
}
object ListUserPoliciesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iam.model.ListUserPoliciesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iam.model.ListUserPoliciesRequest =
      zio.aws.iam.model.ListUserPoliciesRequest(
        userName,
        marker.map(value => value),
        maxItems.map(value => value)
      )
    def userName: ExistingUserNameType
    def marker: Optional[MarkerType]
    def maxItems: Optional[MaxItemsType]
    def getUserName: ZIO[Any, Nothing, ExistingUserNameType] =
      ZIO.succeed(userName)
    def getMarker: ZIO[Any, AwsError, MarkerType] =
      AwsError.unwrapOptionField("marker", marker)
    def getMaxItems: ZIO[Any, AwsError, MaxItemsType] =
      AwsError.unwrapOptionField("maxItems", maxItems)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iam.model.ListUserPoliciesRequest
  ) extends zio.aws.iam.model.ListUserPoliciesRequest.ReadOnly {
    override val userName: ExistingUserNameType =
      zio.aws.iam.model.primitives.ExistingUserNameType(impl.userName())
    override val marker: Optional[MarkerType] = zio.aws.core.internal
      .optionalFromNullable(impl.marker())
      .map(value => zio.aws.iam.model.primitives.MarkerType(value))
    override val maxItems: Optional[MaxItemsType] = zio.aws.core.internal
      .optionalFromNullable(impl.maxItems())
      .map(value => zio.aws.iam.model.primitives.MaxItemsType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iam.model.ListUserPoliciesRequest
  ): zio.aws.iam.model.ListUserPoliciesRequest.ReadOnly = new Wrapper(impl)
}
