package zio.aws.iam.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.iam.model.primitives.{BooleanType, DateType, UserNameType}
import scala.jdk.CollectionConverters.*
final case class LoginProfile(
    userName: UserNameType,
    createDate: DateType,
    passwordResetRequired: Optional[BooleanType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iam.model.LoginProfile = {
    import LoginProfile.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iam.model.LoginProfile
      .builder()
      .userName(UserNameType.unwrap(userName): java.lang.String)
      .createDate(DateType.unwrap(createDate): Instant)
      .optionallyWith(
        passwordResetRequired.map(value =>
          BooleanType.unwrap(value): java.lang.Boolean
        )
      )(_.passwordResetRequired)
      .build()
  }
  def asReadOnly: zio.aws.iam.model.LoginProfile.ReadOnly =
    zio.aws.iam.model.LoginProfile.wrap(buildAwsValue())
}
object LoginProfile {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.iam.model.LoginProfile] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iam.model.LoginProfile =
      zio.aws.iam.model.LoginProfile(
        userName,
        createDate,
        passwordResetRequired.map(value => value)
      )
    def userName: UserNameType
    def createDate: DateType
    def passwordResetRequired: Optional[BooleanType]
    def getUserName: ZIO[Any, Nothing, UserNameType] = ZIO.succeed(userName)
    def getCreateDate: ZIO[Any, Nothing, DateType] = ZIO.succeed(createDate)
    def getPasswordResetRequired: ZIO[Any, AwsError, BooleanType] =
      AwsError.unwrapOptionField("passwordResetRequired", passwordResetRequired)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iam.model.LoginProfile
  ) extends zio.aws.iam.model.LoginProfile.ReadOnly {
    override val userName: UserNameType =
      zio.aws.iam.model.primitives.UserNameType(impl.userName())
    override val createDate: DateType =
      zio.aws.iam.model.primitives.DateType(impl.createDate())
    override val passwordResetRequired: Optional[BooleanType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.passwordResetRequired())
        .map(value => zio.aws.iam.model.primitives.BooleanType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iam.model.LoginProfile
  ): zio.aws.iam.model.LoginProfile.ReadOnly = new Wrapper(impl)
}
