package zio.aws.iam.model
import zio.aws.iam.model.primitives.BooleanType
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class PermissionsBoundaryDecisionDetail(
    allowedByPermissionsBoundary: Optional[BooleanType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iam.model.PermissionsBoundaryDecisionDetail = {
    import PermissionsBoundaryDecisionDetail.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iam.model.PermissionsBoundaryDecisionDetail
      .builder()
      .optionallyWith(
        allowedByPermissionsBoundary.map(value =>
          BooleanType.unwrap(value): java.lang.Boolean
        )
      )(_.allowedByPermissionsBoundary)
      .build()
  }
  def asReadOnly: zio.aws.iam.model.PermissionsBoundaryDecisionDetail.ReadOnly =
    zio.aws.iam.model.PermissionsBoundaryDecisionDetail.wrap(buildAwsValue())
}
object PermissionsBoundaryDecisionDetail {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iam.model.PermissionsBoundaryDecisionDetail
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iam.model.PermissionsBoundaryDecisionDetail =
      zio.aws.iam.model.PermissionsBoundaryDecisionDetail(
        allowedByPermissionsBoundary.map(value => value)
      )
    def allowedByPermissionsBoundary: Optional[BooleanType]
    def getAllowedByPermissionsBoundary: ZIO[Any, AwsError, BooleanType] =
      AwsError.unwrapOptionField(
        "allowedByPermissionsBoundary",
        allowedByPermissionsBoundary
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iam.model.PermissionsBoundaryDecisionDetail
  ) extends zio.aws.iam.model.PermissionsBoundaryDecisionDetail.ReadOnly {
    override val allowedByPermissionsBoundary: Optional[BooleanType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.allowedByPermissionsBoundary())
        .map(value => zio.aws.iam.model.primitives.BooleanType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iam.model.PermissionsBoundaryDecisionDetail
  ): zio.aws.iam.model.PermissionsBoundaryDecisionDetail.ReadOnly = new Wrapper(
    impl
  )
}
