package zio.aws.iam.model
import scala.jdk.CollectionConverters.*
sealed trait PolicyEvaluationDecisionType {
  def unwrap
      : software.amazon.awssdk.services.iam.model.PolicyEvaluationDecisionType
}
object PolicyEvaluationDecisionType {
  def wrap(
      value: software.amazon.awssdk.services.iam.model.PolicyEvaluationDecisionType
  ): zio.aws.iam.model.PolicyEvaluationDecisionType = value match {
    case software.amazon.awssdk.services.iam.model.PolicyEvaluationDecisionType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.iam.model.PolicyEvaluationDecisionType.ALLOWED =>
      val r = allowed
      r
    case software.amazon.awssdk.services.iam.model.PolicyEvaluationDecisionType.EXPLICIT_DENY =>
      val r = explicitDeny
      r
    case software.amazon.awssdk.services.iam.model.PolicyEvaluationDecisionType.IMPLICIT_DENY =>
      val r = implicitDeny
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.iam.model.PolicyEvaluationDecisionType {
    override def unwrap
        : software.amazon.awssdk.services.iam.model.PolicyEvaluationDecisionType =
      software.amazon.awssdk.services.iam.model.PolicyEvaluationDecisionType.UNKNOWN_TO_SDK_VERSION
  }
  case object allowed extends zio.aws.iam.model.PolicyEvaluationDecisionType {
    override def unwrap
        : software.amazon.awssdk.services.iam.model.PolicyEvaluationDecisionType =
      software.amazon.awssdk.services.iam.model.PolicyEvaluationDecisionType.ALLOWED
  }
  case object explicitDeny
      extends zio.aws.iam.model.PolicyEvaluationDecisionType {
    override def unwrap
        : software.amazon.awssdk.services.iam.model.PolicyEvaluationDecisionType =
      software.amazon.awssdk.services.iam.model.PolicyEvaluationDecisionType.EXPLICIT_DENY
  }
  case object implicitDeny
      extends zio.aws.iam.model.PolicyEvaluationDecisionType {
    override def unwrap
        : software.amazon.awssdk.services.iam.model.PolicyEvaluationDecisionType =
      software.amazon.awssdk.services.iam.model.PolicyEvaluationDecisionType.IMPLICIT_DENY
  }
}
