package zio.aws.iam.model
import zio.aws.iam.model.primitives.{EntityNameType, ArnType, PolicyNameType}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class PolicyGrantingServiceAccess(
    policyName: PolicyNameType,
    policyType: zio.aws.iam.model.PolicyType,
    policyArn: Optional[ArnType] = Optional.Absent,
    entityType: Optional[zio.aws.iam.model.PolicyOwnerEntityType] =
      Optional.Absent,
    entityName: Optional[EntityNameType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iam.model.PolicyGrantingServiceAccess = {
    import PolicyGrantingServiceAccess.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iam.model.PolicyGrantingServiceAccess
      .builder()
      .policyName(PolicyNameType.unwrap(policyName): java.lang.String)
      .policyType(policyType.unwrap)
      .optionallyWith(
        policyArn.map(value => ArnType.unwrap(value): java.lang.String)
      )(_.policyArn)
      .optionallyWith(entityType.map(value => value.unwrap))(_.entityType)
      .optionallyWith(
        entityName.map(value => EntityNameType.unwrap(value): java.lang.String)
      )(_.entityName)
      .build()
  }
  def asReadOnly: zio.aws.iam.model.PolicyGrantingServiceAccess.ReadOnly =
    zio.aws.iam.model.PolicyGrantingServiceAccess.wrap(buildAwsValue())
}
object PolicyGrantingServiceAccess {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iam.model.PolicyGrantingServiceAccess
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iam.model.PolicyGrantingServiceAccess =
      zio.aws.iam.model.PolicyGrantingServiceAccess(
        policyName,
        policyType,
        policyArn.map(value => value),
        entityType.map(value => value),
        entityName.map(value => value)
      )
    def policyName: PolicyNameType
    def policyType: zio.aws.iam.model.PolicyType
    def policyArn: Optional[ArnType]
    def entityType: Optional[zio.aws.iam.model.PolicyOwnerEntityType]
    def entityName: Optional[EntityNameType]
    def getPolicyName: ZIO[Any, Nothing, PolicyNameType] =
      ZIO.succeed(policyName)
    def getPolicyType: ZIO[Any, Nothing, zio.aws.iam.model.PolicyType] =
      ZIO.succeed(policyType)
    def getPolicyArn: ZIO[Any, AwsError, ArnType] =
      AwsError.unwrapOptionField("policyArn", policyArn)
    def getEntityType
        : ZIO[Any, AwsError, zio.aws.iam.model.PolicyOwnerEntityType] =
      AwsError.unwrapOptionField("entityType", entityType)
    def getEntityName: ZIO[Any, AwsError, EntityNameType] =
      AwsError.unwrapOptionField("entityName", entityName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iam.model.PolicyGrantingServiceAccess
  ) extends zio.aws.iam.model.PolicyGrantingServiceAccess.ReadOnly {
    override val policyName: PolicyNameType =
      zio.aws.iam.model.primitives.PolicyNameType(impl.policyName())
    override val policyType: zio.aws.iam.model.PolicyType =
      zio.aws.iam.model.PolicyType.wrap(impl.policyType())
    override val policyArn: Optional[ArnType] = zio.aws.core.internal
      .optionalFromNullable(impl.policyArn())
      .map(value => zio.aws.iam.model.primitives.ArnType(value))
    override val entityType: Optional[zio.aws.iam.model.PolicyOwnerEntityType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.entityType())
        .map(value => zio.aws.iam.model.PolicyOwnerEntityType.wrap(value))
    override val entityName: Optional[EntityNameType] = zio.aws.core.internal
      .optionalFromNullable(impl.entityName())
      .map(value => zio.aws.iam.model.primitives.EntityNameType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iam.model.PolicyGrantingServiceAccess
  ): zio.aws.iam.model.PolicyGrantingServiceAccess.ReadOnly = new Wrapper(impl)
}
