package zio.aws.iam.model
import zio.aws.iam.model.primitives.{IdType, RoleNameType}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class PolicyRole(
    roleName: Optional[RoleNameType] = Optional.Absent,
    roleId: Optional[IdType] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.iam.model.PolicyRole = {
    import PolicyRole.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iam.model.PolicyRole
      .builder()
      .optionallyWith(
        roleName.map(value => RoleNameType.unwrap(value): java.lang.String)
      )(_.roleName)
      .optionallyWith(
        roleId.map(value => IdType.unwrap(value): java.lang.String)
      )(_.roleId)
      .build()
  }
  def asReadOnly: zio.aws.iam.model.PolicyRole.ReadOnly =
    zio.aws.iam.model.PolicyRole.wrap(buildAwsValue())
}
object PolicyRole {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.iam.model.PolicyRole] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iam.model.PolicyRole = zio.aws.iam.model
      .PolicyRole(roleName.map(value => value), roleId.map(value => value))
    def roleName: Optional[RoleNameType]
    def roleId: Optional[IdType]
    def getRoleName: ZIO[Any, AwsError, RoleNameType] =
      AwsError.unwrapOptionField("roleName", roleName)
    def getRoleId: ZIO[Any, AwsError, IdType] =
      AwsError.unwrapOptionField("roleId", roleId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iam.model.PolicyRole
  ) extends zio.aws.iam.model.PolicyRole.ReadOnly {
    override val roleName: Optional[RoleNameType] = zio.aws.core.internal
      .optionalFromNullable(impl.roleName())
      .map(value => zio.aws.iam.model.primitives.RoleNameType(value))
    override val roleId: Optional[IdType] = zio.aws.core.internal
      .optionalFromNullable(impl.roleId())
      .map(value => zio.aws.iam.model.primitives.IdType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iam.model.PolicyRole
  ): zio.aws.iam.model.PolicyRole.ReadOnly = new Wrapper(impl)
}
