package zio.aws.iam.model
import scala.jdk.CollectionConverters.*
sealed trait PolicyType {
  def unwrap: software.amazon.awssdk.services.iam.model.PolicyType
}
object PolicyType {
  def wrap(
      value: software.amazon.awssdk.services.iam.model.PolicyType
  ): zio.aws.iam.model.PolicyType = value match {
    case software.amazon.awssdk.services.iam.model.PolicyType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.iam.model.PolicyType.INLINE =>
      val r = INLINE
      r
    case software.amazon.awssdk.services.iam.model.PolicyType.MANAGED =>
      val r = MANAGED
      r
  }
  case object unknownToSdkVersion extends zio.aws.iam.model.PolicyType {
    override def unwrap: software.amazon.awssdk.services.iam.model.PolicyType =
      software.amazon.awssdk.services.iam.model.PolicyType.UNKNOWN_TO_SDK_VERSION
  }
  case object INLINE extends zio.aws.iam.model.PolicyType {
    override def unwrap: software.amazon.awssdk.services.iam.model.PolicyType =
      software.amazon.awssdk.services.iam.model.PolicyType.INLINE
  }
  case object MANAGED extends zio.aws.iam.model.PolicyType {
    override def unwrap: software.amazon.awssdk.services.iam.model.PolicyType =
      software.amazon.awssdk.services.iam.model.PolicyType.MANAGED
  }
}
