package zio.aws.iam.model
import scala.jdk.CollectionConverters.*
sealed trait PolicyUsageType {
  def unwrap: software.amazon.awssdk.services.iam.model.PolicyUsageType
}
object PolicyUsageType {
  def wrap(
      value: software.amazon.awssdk.services.iam.model.PolicyUsageType
  ): zio.aws.iam.model.PolicyUsageType = value match {
    case software.amazon.awssdk.services.iam.model.PolicyUsageType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.iam.model.PolicyUsageType.PERMISSIONS_POLICY =>
      val r = PermissionsPolicy
      r
    case software.amazon.awssdk.services.iam.model.PolicyUsageType.PERMISSIONS_BOUNDARY =>
      val r = PermissionsBoundary
      r
  }
  case object unknownToSdkVersion extends zio.aws.iam.model.PolicyUsageType {
    override def unwrap
        : software.amazon.awssdk.services.iam.model.PolicyUsageType =
      software.amazon.awssdk.services.iam.model.PolicyUsageType.UNKNOWN_TO_SDK_VERSION
  }
  case object PermissionsPolicy extends zio.aws.iam.model.PolicyUsageType {
    override def unwrap
        : software.amazon.awssdk.services.iam.model.PolicyUsageType =
      software.amazon.awssdk.services.iam.model.PolicyUsageType.PERMISSIONS_POLICY
  }
  case object PermissionsBoundary extends zio.aws.iam.model.PolicyUsageType {
    override def unwrap
        : software.amazon.awssdk.services.iam.model.PolicyUsageType =
      software.amazon.awssdk.services.iam.model.PolicyUsageType.PERMISSIONS_BOUNDARY
  }
}
