package zio.aws.iam.model
import zio.aws.iam.model.primitives.{ArnType, UserNameType}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class PutUserPermissionsBoundaryRequest(
    userName: UserNameType,
    permissionsBoundary: ArnType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iam.model.PutUserPermissionsBoundaryRequest = {
    import PutUserPermissionsBoundaryRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iam.model.PutUserPermissionsBoundaryRequest
      .builder()
      .userName(UserNameType.unwrap(userName): java.lang.String)
      .permissionsBoundary(
        ArnType.unwrap(permissionsBoundary): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.iam.model.PutUserPermissionsBoundaryRequest.ReadOnly =
    zio.aws.iam.model.PutUserPermissionsBoundaryRequest.wrap(buildAwsValue())
}
object PutUserPermissionsBoundaryRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iam.model.PutUserPermissionsBoundaryRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iam.model.PutUserPermissionsBoundaryRequest =
      zio.aws.iam.model
        .PutUserPermissionsBoundaryRequest(userName, permissionsBoundary)
    def userName: UserNameType
    def permissionsBoundary: ArnType
    def getUserName: ZIO[Any, Nothing, UserNameType] = ZIO.succeed(userName)
    def getPermissionsBoundary: ZIO[Any, Nothing, ArnType] =
      ZIO.succeed(permissionsBoundary)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iam.model.PutUserPermissionsBoundaryRequest
  ) extends zio.aws.iam.model.PutUserPermissionsBoundaryRequest.ReadOnly {
    override val userName: UserNameType =
      zio.aws.iam.model.primitives.UserNameType(impl.userName())
    override val permissionsBoundary: ArnType =
      zio.aws.iam.model.primitives.ArnType(impl.permissionsBoundary())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iam.model.PutUserPermissionsBoundaryRequest
  ): zio.aws.iam.model.PutUserPermissionsBoundaryRequest.ReadOnly = new Wrapper(
    impl
  )
}
