package zio.aws.iam.model
import scala.jdk.CollectionConverters.*
sealed trait ReportFormatType {
  def unwrap: software.amazon.awssdk.services.iam.model.ReportFormatType
}
object ReportFormatType {
  def wrap(
      value: software.amazon.awssdk.services.iam.model.ReportFormatType
  ): zio.aws.iam.model.ReportFormatType = value match {
    case software.amazon.awssdk.services.iam.model.ReportFormatType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.iam.model.ReportFormatType.TEXT_CSV =>
      val r = `text/csv`
      r
  }
  case object unknownToSdkVersion extends zio.aws.iam.model.ReportFormatType {
    override def unwrap
        : software.amazon.awssdk.services.iam.model.ReportFormatType =
      software.amazon.awssdk.services.iam.model.ReportFormatType.UNKNOWN_TO_SDK_VERSION
  }
  case object `text/csv` extends zio.aws.iam.model.ReportFormatType {
    override def unwrap
        : software.amazon.awssdk.services.iam.model.ReportFormatType =
      software.amazon.awssdk.services.iam.model.ReportFormatType.TEXT_CSV
  }
}
