package zio.aws.iam.model
import scala.jdk.CollectionConverters.*
sealed trait ReportStateType {
  def unwrap: software.amazon.awssdk.services.iam.model.ReportStateType
}
object ReportStateType {
  def wrap(
      value: software.amazon.awssdk.services.iam.model.ReportStateType
  ): zio.aws.iam.model.ReportStateType = value match {
    case software.amazon.awssdk.services.iam.model.ReportStateType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.iam.model.ReportStateType.STARTED =>
      val r = STARTED
      r
    case software.amazon.awssdk.services.iam.model.ReportStateType.INPROGRESS =>
      val r = INPROGRESS
      r
    case software.amazon.awssdk.services.iam.model.ReportStateType.COMPLETE =>
      val r = COMPLETE
      r
  }
  case object unknownToSdkVersion extends zio.aws.iam.model.ReportStateType {
    override def unwrap
        : software.amazon.awssdk.services.iam.model.ReportStateType =
      software.amazon.awssdk.services.iam.model.ReportStateType.UNKNOWN_TO_SDK_VERSION
  }
  case object STARTED extends zio.aws.iam.model.ReportStateType {
    override def unwrap
        : software.amazon.awssdk.services.iam.model.ReportStateType =
      software.amazon.awssdk.services.iam.model.ReportStateType.STARTED
  }
  case object INPROGRESS extends zio.aws.iam.model.ReportStateType {
    override def unwrap
        : software.amazon.awssdk.services.iam.model.ReportStateType =
      software.amazon.awssdk.services.iam.model.ReportStateType.INPROGRESS
  }
  case object COMPLETE extends zio.aws.iam.model.ReportStateType {
    override def unwrap
        : software.amazon.awssdk.services.iam.model.ReportStateType =
      software.amazon.awssdk.services.iam.model.ReportStateType.COMPLETE
  }
}
