package zio.aws.iam.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.iam.model.primitives.{
  ArnType,
  RoleNameType,
  IdType,
  RoleDescriptionType,
  DateType,
  PolicyDocumentType,
  RoleMaxSessionDurationType,
  PathType
}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class Role(
    path: PathType,
    roleName: RoleNameType,
    roleId: IdType,
    arn: ArnType,
    createDate: DateType,
    assumeRolePolicyDocument: Optional[PolicyDocumentType] = Optional.Absent,
    description: Optional[RoleDescriptionType] = Optional.Absent,
    maxSessionDuration: Optional[RoleMaxSessionDurationType] = Optional.Absent,
    permissionsBoundary: Optional[
      zio.aws.iam.model.AttachedPermissionsBoundary
    ] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.iam.model.Tag]] = Optional.Absent,
    roleLastUsed: Optional[zio.aws.iam.model.RoleLastUsed] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.iam.model.Role = {
    import Role.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iam.model.Role
      .builder()
      .path(PathType.unwrap(path): java.lang.String)
      .roleName(RoleNameType.unwrap(roleName): java.lang.String)
      .roleId(IdType.unwrap(roleId): java.lang.String)
      .arn(ArnType.unwrap(arn): java.lang.String)
      .createDate(DateType.unwrap(createDate): Instant)
      .optionallyWith(
        assumeRolePolicyDocument.map(value =>
          PolicyDocumentType.unwrap(value): java.lang.String
        )
      )(_.assumeRolePolicyDocument)
      .optionallyWith(
        description.map(value =>
          RoleDescriptionType.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        maxSessionDuration.map(value =>
          RoleMaxSessionDurationType.unwrap(value): Integer
        )
      )(_.maxSessionDuration)
      .optionallyWith(permissionsBoundary.map(value => value.buildAwsValue()))(
        _.permissionsBoundary
      )
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(roleLastUsed.map(value => value.buildAwsValue()))(
        _.roleLastUsed
      )
      .build()
  }
  def asReadOnly: zio.aws.iam.model.Role.ReadOnly =
    zio.aws.iam.model.Role.wrap(buildAwsValue())
}
object Role {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.iam.model.Role] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iam.model.Role = zio.aws.iam.model.Role(
      path,
      roleName,
      roleId,
      arn,
      createDate,
      assumeRolePolicyDocument.map(value => value),
      description.map(value => value),
      maxSessionDuration.map(value => value),
      permissionsBoundary.map(value => value.asEditable),
      tags.map(value =>
        value.map { item =>
          item.asEditable
        }
      ),
      roleLastUsed.map(value => value.asEditable)
    )
    def path: PathType
    def roleName: RoleNameType
    def roleId: IdType
    def arn: ArnType
    def createDate: DateType
    def assumeRolePolicyDocument: Optional[PolicyDocumentType]
    def description: Optional[RoleDescriptionType]
    def maxSessionDuration: Optional[RoleMaxSessionDurationType]
    def permissionsBoundary
        : Optional[zio.aws.iam.model.AttachedPermissionsBoundary.ReadOnly]
    def tags: Optional[List[zio.aws.iam.model.Tag.ReadOnly]]
    def roleLastUsed: Optional[zio.aws.iam.model.RoleLastUsed.ReadOnly]
    def getPath: ZIO[Any, Nothing, PathType] = ZIO.succeed(path)
    def getRoleName: ZIO[Any, Nothing, RoleNameType] = ZIO.succeed(roleName)
    def getRoleId: ZIO[Any, Nothing, IdType] = ZIO.succeed(roleId)
    def getArn: ZIO[Any, Nothing, ArnType] = ZIO.succeed(arn)
    def getCreateDate: ZIO[Any, Nothing, DateType] = ZIO.succeed(createDate)
    def getAssumeRolePolicyDocument: ZIO[Any, AwsError, PolicyDocumentType] =
      AwsError.unwrapOptionField(
        "assumeRolePolicyDocument",
        assumeRolePolicyDocument
      )
    def getDescription: ZIO[Any, AwsError, RoleDescriptionType] =
      AwsError.unwrapOptionField("description", description)
    def getMaxSessionDuration: ZIO[Any, AwsError, RoleMaxSessionDurationType] =
      AwsError.unwrapOptionField("maxSessionDuration", maxSessionDuration)
    def getPermissionsBoundary: ZIO[
      Any,
      AwsError,
      zio.aws.iam.model.AttachedPermissionsBoundary.ReadOnly
    ] = AwsError.unwrapOptionField("permissionsBoundary", permissionsBoundary)
    def getTags: ZIO[Any, AwsError, List[zio.aws.iam.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getRoleLastUsed
        : ZIO[Any, AwsError, zio.aws.iam.model.RoleLastUsed.ReadOnly] =
      AwsError.unwrapOptionField("roleLastUsed", roleLastUsed)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iam.model.Role
  ) extends zio.aws.iam.model.Role.ReadOnly {
    override val path: PathType =
      zio.aws.iam.model.primitives.PathType(impl.path())
    override val roleName: RoleNameType =
      zio.aws.iam.model.primitives.RoleNameType(impl.roleName())
    override val roleId: IdType =
      zio.aws.iam.model.primitives.IdType(impl.roleId())
    override val arn: ArnType = zio.aws.iam.model.primitives.ArnType(impl.arn())
    override val createDate: DateType =
      zio.aws.iam.model.primitives.DateType(impl.createDate())
    override val assumeRolePolicyDocument: Optional[PolicyDocumentType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.assumeRolePolicyDocument())
        .map(value => zio.aws.iam.model.primitives.PolicyDocumentType(value))
    override val description: Optional[RoleDescriptionType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value => zio.aws.iam.model.primitives.RoleDescriptionType(value))
    override val maxSessionDuration: Optional[RoleMaxSessionDurationType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxSessionDuration())
        .map(value =>
          zio.aws.iam.model.primitives.RoleMaxSessionDurationType(value)
        )
    override val permissionsBoundary
        : Optional[zio.aws.iam.model.AttachedPermissionsBoundary.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.permissionsBoundary())
        .map(value => zio.aws.iam.model.AttachedPermissionsBoundary.wrap(value))
    override val tags: Optional[List[zio.aws.iam.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.iam.model.Tag.wrap(item)
          }.toList
        )
    override val roleLastUsed
        : Optional[zio.aws.iam.model.RoleLastUsed.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.roleLastUsed())
        .map(value => zio.aws.iam.model.RoleLastUsed.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iam.model.Role
  ): zio.aws.iam.model.Role.ReadOnly = new Wrapper(impl)
}
