package zio.aws.iam.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.iam.model.primitives.{StringType, DateType}
import scala.jdk.CollectionConverters.*
final case class RoleLastUsed(
    lastUsedDate: Optional[DateType] = Optional.Absent,
    region: Optional[StringType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iam.model.RoleLastUsed = {
    import RoleLastUsed.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iam.model.RoleLastUsed
      .builder()
      .optionallyWith(
        lastUsedDate.map(value => DateType.unwrap(value): Instant)
      )(_.lastUsedDate)
      .optionallyWith(region.map(value => value: java.lang.String))(_.region)
      .build()
  }
  def asReadOnly: zio.aws.iam.model.RoleLastUsed.ReadOnly =
    zio.aws.iam.model.RoleLastUsed.wrap(buildAwsValue())
}
object RoleLastUsed {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.iam.model.RoleLastUsed] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iam.model.RoleLastUsed =
      zio.aws.iam.model.RoleLastUsed(
        lastUsedDate.map(value => value),
        region.map(value => value)
      )
    def lastUsedDate: Optional[DateType]
    def region: Optional[StringType]
    def getLastUsedDate: ZIO[Any, AwsError, DateType] =
      AwsError.unwrapOptionField("lastUsedDate", lastUsedDate)
    def getRegion: ZIO[Any, AwsError, StringType] =
      AwsError.unwrapOptionField("region", region)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iam.model.RoleLastUsed
  ) extends zio.aws.iam.model.RoleLastUsed.ReadOnly {
    override val lastUsedDate: Optional[DateType] = zio.aws.core.internal
      .optionalFromNullable(impl.lastUsedDate())
      .map(value => zio.aws.iam.model.primitives.DateType(value))
    override val region: Optional[StringType] = zio.aws.core.internal
      .optionalFromNullable(impl.region())
      .map(value => value: StringType)
  }
  def wrap(
      impl: software.amazon.awssdk.services.iam.model.RoleLastUsed
  ): zio.aws.iam.model.RoleLastUsed.ReadOnly = new Wrapper(impl)
}
