package zio.aws.iam.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.iam.model.primitives.{DateType, ArnType}
import scala.jdk.CollectionConverters.*
final case class SAMLProviderListEntry(
    arn: Optional[ArnType] = Optional.Absent,
    validUntil: Optional[DateType] = Optional.Absent,
    createDate: Optional[DateType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iam.model.SAMLProviderListEntry = {
    import SAMLProviderListEntry.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iam.model.SAMLProviderListEntry
      .builder()
      .optionallyWith(
        arn.map(value => ArnType.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(validUntil.map(value => DateType.unwrap(value): Instant))(
        _.validUntil
      )
      .optionallyWith(createDate.map(value => DateType.unwrap(value): Instant))(
        _.createDate
      )
      .build()
  }
  def asReadOnly: zio.aws.iam.model.SAMLProviderListEntry.ReadOnly =
    zio.aws.iam.model.SAMLProviderListEntry.wrap(buildAwsValue())
}
object SAMLProviderListEntry {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iam.model.SAMLProviderListEntry
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iam.model.SAMLProviderListEntry =
      zio.aws.iam.model.SAMLProviderListEntry(
        arn.map(value => value),
        validUntil.map(value => value),
        createDate.map(value => value)
      )
    def arn: Optional[ArnType]
    def validUntil: Optional[DateType]
    def createDate: Optional[DateType]
    def getArn: ZIO[Any, AwsError, ArnType] =
      AwsError.unwrapOptionField("arn", arn)
    def getValidUntil: ZIO[Any, AwsError, DateType] =
      AwsError.unwrapOptionField("validUntil", validUntil)
    def getCreateDate: ZIO[Any, AwsError, DateType] =
      AwsError.unwrapOptionField("createDate", createDate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iam.model.SAMLProviderListEntry
  ) extends zio.aws.iam.model.SAMLProviderListEntry.ReadOnly {
    override val arn: Optional[ArnType] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => zio.aws.iam.model.primitives.ArnType(value))
    override val validUntil: Optional[DateType] = zio.aws.core.internal
      .optionalFromNullable(impl.validUntil())
      .map(value => zio.aws.iam.model.primitives.DateType(value))
    override val createDate: Optional[DateType] = zio.aws.core.internal
      .optionalFromNullable(impl.createDate())
      .map(value => zio.aws.iam.model.primitives.DateType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iam.model.SAMLProviderListEntry
  ): zio.aws.iam.model.SAMLProviderListEntry.ReadOnly = new Wrapper(impl)
}
