package zio.aws.iam.model
import zio.aws.iam.model.primitives.{DateType, PublicKeyIdType, UserNameType}
import zio.ZIO
import zio.aws.core.BuilderHelper
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class SSHPublicKeyMetadata(
    userName: UserNameType,
    sshPublicKeyId: PublicKeyIdType,
    status: zio.aws.iam.model.StatusType,
    uploadDate: DateType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iam.model.SSHPublicKeyMetadata = {
    import SSHPublicKeyMetadata.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iam.model.SSHPublicKeyMetadata
      .builder()
      .userName(UserNameType.unwrap(userName): java.lang.String)
      .sshPublicKeyId(PublicKeyIdType.unwrap(sshPublicKeyId): java.lang.String)
      .status(status.unwrap)
      .uploadDate(DateType.unwrap(uploadDate): Instant)
      .build()
  }
  def asReadOnly: zio.aws.iam.model.SSHPublicKeyMetadata.ReadOnly =
    zio.aws.iam.model.SSHPublicKeyMetadata.wrap(buildAwsValue())
}
object SSHPublicKeyMetadata {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iam.model.SSHPublicKeyMetadata
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iam.model.SSHPublicKeyMetadata = zio.aws.iam.model
      .SSHPublicKeyMetadata(userName, sshPublicKeyId, status, uploadDate)
    def userName: UserNameType
    def sshPublicKeyId: PublicKeyIdType
    def status: zio.aws.iam.model.StatusType
    def uploadDate: DateType
    def getUserName: ZIO[Any, Nothing, UserNameType] = ZIO.succeed(userName)
    def getSshPublicKeyId: ZIO[Any, Nothing, PublicKeyIdType] =
      ZIO.succeed(sshPublicKeyId)
    def getStatus: ZIO[Any, Nothing, zio.aws.iam.model.StatusType] =
      ZIO.succeed(status)
    def getUploadDate: ZIO[Any, Nothing, DateType] = ZIO.succeed(uploadDate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iam.model.SSHPublicKeyMetadata
  ) extends zio.aws.iam.model.SSHPublicKeyMetadata.ReadOnly {
    override val userName: UserNameType =
      zio.aws.iam.model.primitives.UserNameType(impl.userName())
    override val sshPublicKeyId: PublicKeyIdType =
      zio.aws.iam.model.primitives.PublicKeyIdType(impl.sshPublicKeyId())
    override val status: zio.aws.iam.model.StatusType =
      zio.aws.iam.model.StatusType.wrap(impl.status())
    override val uploadDate: DateType =
      zio.aws.iam.model.primitives.DateType(impl.uploadDate())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iam.model.SSHPublicKeyMetadata
  ): zio.aws.iam.model.SSHPublicKeyMetadata.ReadOnly = new Wrapper(impl)
}
