package zio.aws.iam.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.iam.model.primitives.{
  DateType,
  CertificateBodyType,
  CertificateIdType,
  UserNameType
}
import scala.jdk.CollectionConverters.*
final case class SigningCertificate(
    userName: UserNameType,
    certificateId: CertificateIdType,
    certificateBody: CertificateBodyType,
    status: zio.aws.iam.model.StatusType,
    uploadDate: Optional[DateType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iam.model.SigningCertificate = {
    import SigningCertificate.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iam.model.SigningCertificate
      .builder()
      .userName(UserNameType.unwrap(userName): java.lang.String)
      .certificateId(CertificateIdType.unwrap(certificateId): java.lang.String)
      .certificateBody(
        CertificateBodyType.unwrap(certificateBody): java.lang.String
      )
      .status(status.unwrap)
      .optionallyWith(uploadDate.map(value => DateType.unwrap(value): Instant))(
        _.uploadDate
      )
      .build()
  }
  def asReadOnly: zio.aws.iam.model.SigningCertificate.ReadOnly =
    zio.aws.iam.model.SigningCertificate.wrap(buildAwsValue())
}
object SigningCertificate {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iam.model.SigningCertificate
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iam.model.SigningCertificate =
      zio.aws.iam.model.SigningCertificate(
        userName,
        certificateId,
        certificateBody,
        status,
        uploadDate.map(value => value)
      )
    def userName: UserNameType
    def certificateId: CertificateIdType
    def certificateBody: CertificateBodyType
    def status: zio.aws.iam.model.StatusType
    def uploadDate: Optional[DateType]
    def getUserName: ZIO[Any, Nothing, UserNameType] = ZIO.succeed(userName)
    def getCertificateId: ZIO[Any, Nothing, CertificateIdType] =
      ZIO.succeed(certificateId)
    def getCertificateBody: ZIO[Any, Nothing, CertificateBodyType] =
      ZIO.succeed(certificateBody)
    def getStatus: ZIO[Any, Nothing, zio.aws.iam.model.StatusType] =
      ZIO.succeed(status)
    def getUploadDate: ZIO[Any, AwsError, DateType] =
      AwsError.unwrapOptionField("uploadDate", uploadDate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iam.model.SigningCertificate
  ) extends zio.aws.iam.model.SigningCertificate.ReadOnly {
    override val userName: UserNameType =
      zio.aws.iam.model.primitives.UserNameType(impl.userName())
    override val certificateId: CertificateIdType =
      zio.aws.iam.model.primitives.CertificateIdType(impl.certificateId())
    override val certificateBody: CertificateBodyType =
      zio.aws.iam.model.primitives.CertificateBodyType(impl.certificateBody())
    override val status: zio.aws.iam.model.StatusType =
      zio.aws.iam.model.StatusType.wrap(impl.status())
    override val uploadDate: Optional[DateType] = zio.aws.core.internal
      .optionalFromNullable(impl.uploadDate())
      .map(value => zio.aws.iam.model.primitives.DateType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iam.model.SigningCertificate
  ): zio.aws.iam.model.SigningCertificate.ReadOnly = new Wrapper(impl)
}
