package zio.aws.iam.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.iam.model.primitives.{
  ArnType,
  MaxItemsType,
  PolicyDocumentType,
  ResourceHandlingOptionType,
  ResourceNameType,
  MarkerType,
  ActionNameType
}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class SimulatePrincipalPolicyRequest(
    policySourceArn: ArnType,
    policyInputList: Optional[Iterable[PolicyDocumentType]] = Optional.Absent,
    permissionsBoundaryPolicyInputList: Optional[Iterable[PolicyDocumentType]] =
      Optional.Absent,
    actionNames: Iterable[ActionNameType],
    resourceArns: Optional[Iterable[ResourceNameType]] = Optional.Absent,
    resourcePolicy: Optional[PolicyDocumentType] = Optional.Absent,
    resourceOwner: Optional[ResourceNameType] = Optional.Absent,
    callerArn: Optional[ResourceNameType] = Optional.Absent,
    contextEntries: Optional[Iterable[zio.aws.iam.model.ContextEntry]] =
      Optional.Absent,
    resourceHandlingOption: Optional[ResourceHandlingOptionType] =
      Optional.Absent,
    maxItems: Optional[MaxItemsType] = Optional.Absent,
    marker: Optional[MarkerType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iam.model.SimulatePrincipalPolicyRequest = {
    import SimulatePrincipalPolicyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iam.model.SimulatePrincipalPolicyRequest
      .builder()
      .policySourceArn(ArnType.unwrap(policySourceArn): java.lang.String)
      .optionallyWith(
        policyInputList.map(value =>
          value.map { item =>
            PolicyDocumentType.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.policyInputList)
      .optionallyWith(
        permissionsBoundaryPolicyInputList.map(value =>
          value.map { item =>
            PolicyDocumentType.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.permissionsBoundaryPolicyInputList)
      .actionNames(actionNames.map { item =>
        ActionNameType.unwrap(item): java.lang.String
      }.asJavaCollection)
      .optionallyWith(
        resourceArns.map(value =>
          value.map { item =>
            ResourceNameType.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.resourceArns)
      .optionallyWith(
        resourcePolicy.map(value =>
          PolicyDocumentType.unwrap(value): java.lang.String
        )
      )(_.resourcePolicy)
      .optionallyWith(
        resourceOwner.map(value =>
          ResourceNameType.unwrap(value): java.lang.String
        )
      )(_.resourceOwner)
      .optionallyWith(
        callerArn.map(value => ResourceNameType.unwrap(value): java.lang.String)
      )(_.callerArn)
      .optionallyWith(
        contextEntries.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.contextEntries)
      .optionallyWith(
        resourceHandlingOption.map(value =>
          ResourceHandlingOptionType.unwrap(value): java.lang.String
        )
      )(_.resourceHandlingOption)
      .optionallyWith(
        maxItems.map(value => MaxItemsType.unwrap(value): Integer)
      )(_.maxItems)
      .optionallyWith(
        marker.map(value => MarkerType.unwrap(value): java.lang.String)
      )(_.marker)
      .build()
  }
  def asReadOnly: zio.aws.iam.model.SimulatePrincipalPolicyRequest.ReadOnly =
    zio.aws.iam.model.SimulatePrincipalPolicyRequest.wrap(buildAwsValue())
}
object SimulatePrincipalPolicyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iam.model.SimulatePrincipalPolicyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iam.model.SimulatePrincipalPolicyRequest =
      zio.aws.iam.model.SimulatePrincipalPolicyRequest(
        policySourceArn,
        policyInputList.map(value => value),
        permissionsBoundaryPolicyInputList.map(value => value),
        actionNames,
        resourceArns.map(value => value),
        resourcePolicy.map(value => value),
        resourceOwner.map(value => value),
        callerArn.map(value => value),
        contextEntries.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        resourceHandlingOption.map(value => value),
        maxItems.map(value => value),
        marker.map(value => value)
      )
    def policySourceArn: ArnType
    def policyInputList: Optional[List[PolicyDocumentType]]
    def permissionsBoundaryPolicyInputList: Optional[List[PolicyDocumentType]]
    def actionNames: List[ActionNameType]
    def resourceArns: Optional[List[ResourceNameType]]
    def resourcePolicy: Optional[PolicyDocumentType]
    def resourceOwner: Optional[ResourceNameType]
    def callerArn: Optional[ResourceNameType]
    def contextEntries: Optional[List[zio.aws.iam.model.ContextEntry.ReadOnly]]
    def resourceHandlingOption: Optional[ResourceHandlingOptionType]
    def maxItems: Optional[MaxItemsType]
    def marker: Optional[MarkerType]
    def getPolicySourceArn: ZIO[Any, Nothing, ArnType] =
      ZIO.succeed(policySourceArn)
    def getPolicyInputList: ZIO[Any, AwsError, List[PolicyDocumentType]] =
      AwsError.unwrapOptionField("policyInputList", policyInputList)
    def getPermissionsBoundaryPolicyInputList
        : ZIO[Any, AwsError, List[PolicyDocumentType]] =
      AwsError.unwrapOptionField(
        "permissionsBoundaryPolicyInputList",
        permissionsBoundaryPolicyInputList
      )
    def getActionNames: ZIO[Any, Nothing, List[ActionNameType]] =
      ZIO.succeed(actionNames)
    def getResourceArns: ZIO[Any, AwsError, List[ResourceNameType]] =
      AwsError.unwrapOptionField("resourceArns", resourceArns)
    def getResourcePolicy: ZIO[Any, AwsError, PolicyDocumentType] =
      AwsError.unwrapOptionField("resourcePolicy", resourcePolicy)
    def getResourceOwner: ZIO[Any, AwsError, ResourceNameType] =
      AwsError.unwrapOptionField("resourceOwner", resourceOwner)
    def getCallerArn: ZIO[Any, AwsError, ResourceNameType] =
      AwsError.unwrapOptionField("callerArn", callerArn)
    def getContextEntries
        : ZIO[Any, AwsError, List[zio.aws.iam.model.ContextEntry.ReadOnly]] =
      AwsError.unwrapOptionField("contextEntries", contextEntries)
    def getResourceHandlingOption
        : ZIO[Any, AwsError, ResourceHandlingOptionType] = AwsError
      .unwrapOptionField("resourceHandlingOption", resourceHandlingOption)
    def getMaxItems: ZIO[Any, AwsError, MaxItemsType] =
      AwsError.unwrapOptionField("maxItems", maxItems)
    def getMarker: ZIO[Any, AwsError, MarkerType] =
      AwsError.unwrapOptionField("marker", marker)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iam.model.SimulatePrincipalPolicyRequest
  ) extends zio.aws.iam.model.SimulatePrincipalPolicyRequest.ReadOnly {
    override val policySourceArn: ArnType =
      zio.aws.iam.model.primitives.ArnType(impl.policySourceArn())
    override val policyInputList: Optional[List[PolicyDocumentType]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.policyInputList())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.iam.model.primitives.PolicyDocumentType(item)
          }.toList
        )
    override val permissionsBoundaryPolicyInputList
        : Optional[List[PolicyDocumentType]] = zio.aws.core.internal
      .optionalFromNullable(impl.permissionsBoundaryPolicyInputList())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.iam.model.primitives.PolicyDocumentType(item)
        }.toList
      )
    override val actionNames: List[ActionNameType] = impl
      .actionNames()
      .asScala
      .map { item =>
        zio.aws.iam.model.primitives.ActionNameType(item)
      }
      .toList
    override val resourceArns: Optional[List[ResourceNameType]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resourceArns())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.iam.model.primitives.ResourceNameType(item)
          }.toList
        )
    override val resourcePolicy: Optional[PolicyDocumentType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resourcePolicy())
        .map(value => zio.aws.iam.model.primitives.PolicyDocumentType(value))
    override val resourceOwner: Optional[ResourceNameType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resourceOwner())
        .map(value => zio.aws.iam.model.primitives.ResourceNameType(value))
    override val callerArn: Optional[ResourceNameType] = zio.aws.core.internal
      .optionalFromNullable(impl.callerArn())
      .map(value => zio.aws.iam.model.primitives.ResourceNameType(value))
    override val contextEntries
        : Optional[List[zio.aws.iam.model.ContextEntry.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.contextEntries())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.iam.model.ContextEntry.wrap(item)
          }.toList
        )
    override val resourceHandlingOption: Optional[ResourceHandlingOptionType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resourceHandlingOption())
        .map(value =>
          zio.aws.iam.model.primitives.ResourceHandlingOptionType(value)
        )
    override val maxItems: Optional[MaxItemsType] = zio.aws.core.internal
      .optionalFromNullable(impl.maxItems())
      .map(value => zio.aws.iam.model.primitives.MaxItemsType(value))
    override val marker: Optional[MarkerType] = zio.aws.core.internal
      .optionalFromNullable(impl.marker())
      .map(value => zio.aws.iam.model.primitives.MarkerType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iam.model.SimulatePrincipalPolicyRequest
  ): zio.aws.iam.model.SimulatePrincipalPolicyRequest.ReadOnly = new Wrapper(
    impl
  )
}
