package zio.aws.iam.model
import scala.jdk.CollectionConverters.*
sealed trait SortKeyType {
  def unwrap: software.amazon.awssdk.services.iam.model.SortKeyType
}
object SortKeyType {
  def wrap(
      value: software.amazon.awssdk.services.iam.model.SortKeyType
  ): zio.aws.iam.model.SortKeyType = value match {
    case software.amazon.awssdk.services.iam.model.SortKeyType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.iam.model.SortKeyType.SERVICE_NAMESPACE_ASCENDING =>
      val r = SERVICE_NAMESPACE_ASCENDING
      r
    case software.amazon.awssdk.services.iam.model.SortKeyType.SERVICE_NAMESPACE_DESCENDING =>
      val r = SERVICE_NAMESPACE_DESCENDING
      r
    case software.amazon.awssdk.services.iam.model.SortKeyType.LAST_AUTHENTICATED_TIME_ASCENDING =>
      val r = LAST_AUTHENTICATED_TIME_ASCENDING
      r
    case software.amazon.awssdk.services.iam.model.SortKeyType.LAST_AUTHENTICATED_TIME_DESCENDING =>
      val r = LAST_AUTHENTICATED_TIME_DESCENDING
      r
  }
  case object unknownToSdkVersion extends zio.aws.iam.model.SortKeyType {
    override def unwrap: software.amazon.awssdk.services.iam.model.SortKeyType =
      software.amazon.awssdk.services.iam.model.SortKeyType.UNKNOWN_TO_SDK_VERSION
  }
  case object SERVICE_NAMESPACE_ASCENDING
      extends zio.aws.iam.model.SortKeyType {
    override def unwrap: software.amazon.awssdk.services.iam.model.SortKeyType =
      software.amazon.awssdk.services.iam.model.SortKeyType.SERVICE_NAMESPACE_ASCENDING
  }
  case object SERVICE_NAMESPACE_DESCENDING
      extends zio.aws.iam.model.SortKeyType {
    override def unwrap: software.amazon.awssdk.services.iam.model.SortKeyType =
      software.amazon.awssdk.services.iam.model.SortKeyType.SERVICE_NAMESPACE_DESCENDING
  }
  case object LAST_AUTHENTICATED_TIME_ASCENDING
      extends zio.aws.iam.model.SortKeyType {
    override def unwrap: software.amazon.awssdk.services.iam.model.SortKeyType =
      software.amazon.awssdk.services.iam.model.SortKeyType.LAST_AUTHENTICATED_TIME_ASCENDING
  }
  case object LAST_AUTHENTICATED_TIME_DESCENDING
      extends zio.aws.iam.model.SortKeyType {
    override def unwrap: software.amazon.awssdk.services.iam.model.SortKeyType =
      software.amazon.awssdk.services.iam.model.SortKeyType.LAST_AUTHENTICATED_TIME_DESCENDING
  }
}
