package zio.aws.iam.model
import scala.jdk.CollectionConverters.*
sealed trait SummaryKeyType {
  def unwrap: software.amazon.awssdk.services.iam.model.SummaryKeyType
}
object SummaryKeyType {
  def wrap(
      value: software.amazon.awssdk.services.iam.model.SummaryKeyType
  ): zio.aws.iam.model.SummaryKeyType = value match {
    case software.amazon.awssdk.services.iam.model.SummaryKeyType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.iam.model.SummaryKeyType.USERS =>
      val r = Users
      r
    case software.amazon.awssdk.services.iam.model.SummaryKeyType.USERS_QUOTA =>
      val r = UsersQuota
      r
    case software.amazon.awssdk.services.iam.model.SummaryKeyType.GROUPS =>
      val r = Groups
      r
    case software.amazon.awssdk.services.iam.model.SummaryKeyType.GROUPS_QUOTA =>
      val r = GroupsQuota
      r
    case software.amazon.awssdk.services.iam.model.SummaryKeyType.SERVER_CERTIFICATES =>
      val r = ServerCertificates
      r
    case software.amazon.awssdk.services.iam.model.SummaryKeyType.SERVER_CERTIFICATES_QUOTA =>
      val r = ServerCertificatesQuota
      r
    case software.amazon.awssdk.services.iam.model.SummaryKeyType.USER_POLICY_SIZE_QUOTA =>
      val r = UserPolicySizeQuota
      r
    case software.amazon.awssdk.services.iam.model.SummaryKeyType.GROUP_POLICY_SIZE_QUOTA =>
      val r = GroupPolicySizeQuota
      r
    case software.amazon.awssdk.services.iam.model.SummaryKeyType.GROUPS_PER_USER_QUOTA =>
      val r = GroupsPerUserQuota
      r
    case software.amazon.awssdk.services.iam.model.SummaryKeyType.SIGNING_CERTIFICATES_PER_USER_QUOTA =>
      val r = SigningCertificatesPerUserQuota
      r
    case software.amazon.awssdk.services.iam.model.SummaryKeyType.ACCESS_KEYS_PER_USER_QUOTA =>
      val r = AccessKeysPerUserQuota
      r
    case software.amazon.awssdk.services.iam.model.SummaryKeyType.MFA_DEVICES =>
      val r = MFADevices
      r
    case software.amazon.awssdk.services.iam.model.SummaryKeyType.MFA_DEVICES_IN_USE =>
      val r = MFADevicesInUse
      r
    case software.amazon.awssdk.services.iam.model.SummaryKeyType.ACCOUNT_MFA_ENABLED =>
      val r = AccountMFAEnabled
      r
    case software.amazon.awssdk.services.iam.model.SummaryKeyType.ACCOUNT_ACCESS_KEYS_PRESENT =>
      val r = AccountAccessKeysPresent
      r
    case software.amazon.awssdk.services.iam.model.SummaryKeyType.ACCOUNT_SIGNING_CERTIFICATES_PRESENT =>
      val r = AccountSigningCertificatesPresent
      r
    case software.amazon.awssdk.services.iam.model.SummaryKeyType.ATTACHED_POLICIES_PER_GROUP_QUOTA =>
      val r = AttachedPoliciesPerGroupQuota
      r
    case software.amazon.awssdk.services.iam.model.SummaryKeyType.ATTACHED_POLICIES_PER_ROLE_QUOTA =>
      val r = AttachedPoliciesPerRoleQuota
      r
    case software.amazon.awssdk.services.iam.model.SummaryKeyType.ATTACHED_POLICIES_PER_USER_QUOTA =>
      val r = AttachedPoliciesPerUserQuota
      r
    case software.amazon.awssdk.services.iam.model.SummaryKeyType.POLICIES =>
      val r = Policies
      r
    case software.amazon.awssdk.services.iam.model.SummaryKeyType.POLICIES_QUOTA =>
      val r = PoliciesQuota
      r
    case software.amazon.awssdk.services.iam.model.SummaryKeyType.POLICY_SIZE_QUOTA =>
      val r = PolicySizeQuota
      r
    case software.amazon.awssdk.services.iam.model.SummaryKeyType.POLICY_VERSIONS_IN_USE =>
      val r = PolicyVersionsInUse
      r
    case software.amazon.awssdk.services.iam.model.SummaryKeyType.POLICY_VERSIONS_IN_USE_QUOTA =>
      val r = PolicyVersionsInUseQuota
      r
    case software.amazon.awssdk.services.iam.model.SummaryKeyType.VERSIONS_PER_POLICY_QUOTA =>
      val r = VersionsPerPolicyQuota
      r
    case software.amazon.awssdk.services.iam.model.SummaryKeyType.GLOBAL_ENDPOINT_TOKEN_VERSION =>
      val r = GlobalEndpointTokenVersion
      r
  }
  case object unknownToSdkVersion extends zio.aws.iam.model.SummaryKeyType {
    override def unwrap
        : software.amazon.awssdk.services.iam.model.SummaryKeyType =
      software.amazon.awssdk.services.iam.model.SummaryKeyType.UNKNOWN_TO_SDK_VERSION
  }
  case object Users extends zio.aws.iam.model.SummaryKeyType {
    override def unwrap
        : software.amazon.awssdk.services.iam.model.SummaryKeyType =
      software.amazon.awssdk.services.iam.model.SummaryKeyType.USERS
  }
  case object UsersQuota extends zio.aws.iam.model.SummaryKeyType {
    override def unwrap
        : software.amazon.awssdk.services.iam.model.SummaryKeyType =
      software.amazon.awssdk.services.iam.model.SummaryKeyType.USERS_QUOTA
  }
  case object Groups extends zio.aws.iam.model.SummaryKeyType {
    override def unwrap
        : software.amazon.awssdk.services.iam.model.SummaryKeyType =
      software.amazon.awssdk.services.iam.model.SummaryKeyType.GROUPS
  }
  case object GroupsQuota extends zio.aws.iam.model.SummaryKeyType {
    override def unwrap
        : software.amazon.awssdk.services.iam.model.SummaryKeyType =
      software.amazon.awssdk.services.iam.model.SummaryKeyType.GROUPS_QUOTA
  }
  case object ServerCertificates extends zio.aws.iam.model.SummaryKeyType {
    override def unwrap
        : software.amazon.awssdk.services.iam.model.SummaryKeyType =
      software.amazon.awssdk.services.iam.model.SummaryKeyType.SERVER_CERTIFICATES
  }
  case object ServerCertificatesQuota extends zio.aws.iam.model.SummaryKeyType {
    override def unwrap
        : software.amazon.awssdk.services.iam.model.SummaryKeyType =
      software.amazon.awssdk.services.iam.model.SummaryKeyType.SERVER_CERTIFICATES_QUOTA
  }
  case object UserPolicySizeQuota extends zio.aws.iam.model.SummaryKeyType {
    override def unwrap
        : software.amazon.awssdk.services.iam.model.SummaryKeyType =
      software.amazon.awssdk.services.iam.model.SummaryKeyType.USER_POLICY_SIZE_QUOTA
  }
  case object GroupPolicySizeQuota extends zio.aws.iam.model.SummaryKeyType {
    override def unwrap
        : software.amazon.awssdk.services.iam.model.SummaryKeyType =
      software.amazon.awssdk.services.iam.model.SummaryKeyType.GROUP_POLICY_SIZE_QUOTA
  }
  case object GroupsPerUserQuota extends zio.aws.iam.model.SummaryKeyType {
    override def unwrap
        : software.amazon.awssdk.services.iam.model.SummaryKeyType =
      software.amazon.awssdk.services.iam.model.SummaryKeyType.GROUPS_PER_USER_QUOTA
  }
  case object SigningCertificatesPerUserQuota
      extends zio.aws.iam.model.SummaryKeyType {
    override def unwrap
        : software.amazon.awssdk.services.iam.model.SummaryKeyType =
      software.amazon.awssdk.services.iam.model.SummaryKeyType.SIGNING_CERTIFICATES_PER_USER_QUOTA
  }
  case object AccessKeysPerUserQuota extends zio.aws.iam.model.SummaryKeyType {
    override def unwrap
        : software.amazon.awssdk.services.iam.model.SummaryKeyType =
      software.amazon.awssdk.services.iam.model.SummaryKeyType.ACCESS_KEYS_PER_USER_QUOTA
  }
  case object MFADevices extends zio.aws.iam.model.SummaryKeyType {
    override def unwrap
        : software.amazon.awssdk.services.iam.model.SummaryKeyType =
      software.amazon.awssdk.services.iam.model.SummaryKeyType.MFA_DEVICES
  }
  case object MFADevicesInUse extends zio.aws.iam.model.SummaryKeyType {
    override def unwrap
        : software.amazon.awssdk.services.iam.model.SummaryKeyType =
      software.amazon.awssdk.services.iam.model.SummaryKeyType.MFA_DEVICES_IN_USE
  }
  case object AccountMFAEnabled extends zio.aws.iam.model.SummaryKeyType {
    override def unwrap
        : software.amazon.awssdk.services.iam.model.SummaryKeyType =
      software.amazon.awssdk.services.iam.model.SummaryKeyType.ACCOUNT_MFA_ENABLED
  }
  case object AccountAccessKeysPresent
      extends zio.aws.iam.model.SummaryKeyType {
    override def unwrap
        : software.amazon.awssdk.services.iam.model.SummaryKeyType =
      software.amazon.awssdk.services.iam.model.SummaryKeyType.ACCOUNT_ACCESS_KEYS_PRESENT
  }
  case object AccountSigningCertificatesPresent
      extends zio.aws.iam.model.SummaryKeyType {
    override def unwrap
        : software.amazon.awssdk.services.iam.model.SummaryKeyType =
      software.amazon.awssdk.services.iam.model.SummaryKeyType.ACCOUNT_SIGNING_CERTIFICATES_PRESENT
  }
  case object AttachedPoliciesPerGroupQuota
      extends zio.aws.iam.model.SummaryKeyType {
    override def unwrap
        : software.amazon.awssdk.services.iam.model.SummaryKeyType =
      software.amazon.awssdk.services.iam.model.SummaryKeyType.ATTACHED_POLICIES_PER_GROUP_QUOTA
  }
  case object AttachedPoliciesPerRoleQuota
      extends zio.aws.iam.model.SummaryKeyType {
    override def unwrap
        : software.amazon.awssdk.services.iam.model.SummaryKeyType =
      software.amazon.awssdk.services.iam.model.SummaryKeyType.ATTACHED_POLICIES_PER_ROLE_QUOTA
  }
  case object AttachedPoliciesPerUserQuota
      extends zio.aws.iam.model.SummaryKeyType {
    override def unwrap
        : software.amazon.awssdk.services.iam.model.SummaryKeyType =
      software.amazon.awssdk.services.iam.model.SummaryKeyType.ATTACHED_POLICIES_PER_USER_QUOTA
  }
  case object Policies extends zio.aws.iam.model.SummaryKeyType {
    override def unwrap
        : software.amazon.awssdk.services.iam.model.SummaryKeyType =
      software.amazon.awssdk.services.iam.model.SummaryKeyType.POLICIES
  }
  case object PoliciesQuota extends zio.aws.iam.model.SummaryKeyType {
    override def unwrap
        : software.amazon.awssdk.services.iam.model.SummaryKeyType =
      software.amazon.awssdk.services.iam.model.SummaryKeyType.POLICIES_QUOTA
  }
  case object PolicySizeQuota extends zio.aws.iam.model.SummaryKeyType {
    override def unwrap
        : software.amazon.awssdk.services.iam.model.SummaryKeyType =
      software.amazon.awssdk.services.iam.model.SummaryKeyType.POLICY_SIZE_QUOTA
  }
  case object PolicyVersionsInUse extends zio.aws.iam.model.SummaryKeyType {
    override def unwrap
        : software.amazon.awssdk.services.iam.model.SummaryKeyType =
      software.amazon.awssdk.services.iam.model.SummaryKeyType.POLICY_VERSIONS_IN_USE
  }
  case object PolicyVersionsInUseQuota
      extends zio.aws.iam.model.SummaryKeyType {
    override def unwrap
        : software.amazon.awssdk.services.iam.model.SummaryKeyType =
      software.amazon.awssdk.services.iam.model.SummaryKeyType.POLICY_VERSIONS_IN_USE_QUOTA
  }
  case object VersionsPerPolicyQuota extends zio.aws.iam.model.SummaryKeyType {
    override def unwrap
        : software.amazon.awssdk.services.iam.model.SummaryKeyType =
      software.amazon.awssdk.services.iam.model.SummaryKeyType.VERSIONS_PER_POLICY_QUOTA
  }
  case object GlobalEndpointTokenVersion
      extends zio.aws.iam.model.SummaryKeyType {
    override def unwrap
        : software.amazon.awssdk.services.iam.model.SummaryKeyType =
      software.amazon.awssdk.services.iam.model.SummaryKeyType.GLOBAL_ENDPOINT_TOKEN_VERSION
  }
}
