package zio.aws.iam.model
import zio.aws.iam.model.primitives.SerialNumberType
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class TagMfaDeviceRequest(
    serialNumber: SerialNumberType,
    tags: Iterable[zio.aws.iam.model.Tag]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iam.model.TagMfaDeviceRequest = {
    import TagMfaDeviceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iam.model.TagMfaDeviceRequest
      .builder()
      .serialNumber(SerialNumberType.unwrap(serialNumber): java.lang.String)
      .tags(tags.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.iam.model.TagMfaDeviceRequest.ReadOnly =
    zio.aws.iam.model.TagMfaDeviceRequest.wrap(buildAwsValue())
}
object TagMfaDeviceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iam.model.TagMfaDeviceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iam.model.TagMfaDeviceRequest =
      zio.aws.iam.model.TagMfaDeviceRequest(
        serialNumber,
        tags.map { item =>
          item.asEditable
        }
      )
    def serialNumber: SerialNumberType
    def tags: List[zio.aws.iam.model.Tag.ReadOnly]
    def getSerialNumber: ZIO[Any, Nothing, SerialNumberType] =
      ZIO.succeed(serialNumber)
    def getTags: ZIO[Any, Nothing, List[zio.aws.iam.model.Tag.ReadOnly]] =
      ZIO.succeed(tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iam.model.TagMfaDeviceRequest
  ) extends zio.aws.iam.model.TagMfaDeviceRequest.ReadOnly {
    override val serialNumber: SerialNumberType =
      zio.aws.iam.model.primitives.SerialNumberType(impl.serialNumber())
    override val tags: List[zio.aws.iam.model.Tag.ReadOnly] = impl
      .tags()
      .asScala
      .map { item =>
        zio.aws.iam.model.Tag.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.iam.model.TagMfaDeviceRequest
  ): zio.aws.iam.model.TagMfaDeviceRequest.ReadOnly = new Wrapper(impl)
}
