package zio.aws.iam.model
import zio.aws.iam.model.primitives.ArnType
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class TagOpenIdConnectProviderRequest(
    openIDConnectProviderArn: ArnType,
    tags: Iterable[zio.aws.iam.model.Tag]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iam.model.TagOpenIdConnectProviderRequest = {
    import TagOpenIdConnectProviderRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iam.model.TagOpenIdConnectProviderRequest
      .builder()
      .openIDConnectProviderArn(
        ArnType.unwrap(openIDConnectProviderArn): java.lang.String
      )
      .tags(tags.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.iam.model.TagOpenIdConnectProviderRequest.ReadOnly =
    zio.aws.iam.model.TagOpenIdConnectProviderRequest.wrap(buildAwsValue())
}
object TagOpenIdConnectProviderRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iam.model.TagOpenIdConnectProviderRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iam.model.TagOpenIdConnectProviderRequest =
      zio.aws.iam.model.TagOpenIdConnectProviderRequest(
        openIDConnectProviderArn,
        tags.map { item =>
          item.asEditable
        }
      )
    def openIDConnectProviderArn: ArnType
    def tags: List[zio.aws.iam.model.Tag.ReadOnly]
    def getOpenIDConnectProviderArn: ZIO[Any, Nothing, ArnType] =
      ZIO.succeed(openIDConnectProviderArn)
    def getTags: ZIO[Any, Nothing, List[zio.aws.iam.model.Tag.ReadOnly]] =
      ZIO.succeed(tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iam.model.TagOpenIdConnectProviderRequest
  ) extends zio.aws.iam.model.TagOpenIdConnectProviderRequest.ReadOnly {
    override val openIDConnectProviderArn: ArnType =
      zio.aws.iam.model.primitives.ArnType(impl.openIDConnectProviderArn())
    override val tags: List[zio.aws.iam.model.Tag.ReadOnly] = impl
      .tags()
      .asScala
      .map { item =>
        zio.aws.iam.model.Tag.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.iam.model.TagOpenIdConnectProviderRequest
  ): zio.aws.iam.model.TagOpenIdConnectProviderRequest.ReadOnly = new Wrapper(
    impl
  )
}
