package zio.aws.iam.model
import zio.aws.iam.model.primitives.ArnType
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class TagPolicyRequest(
    policyArn: ArnType,
    tags: Iterable[zio.aws.iam.model.Tag]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iam.model.TagPolicyRequest = {
    import TagPolicyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iam.model.TagPolicyRequest
      .builder()
      .policyArn(ArnType.unwrap(policyArn): java.lang.String)
      .tags(tags.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.iam.model.TagPolicyRequest.ReadOnly =
    zio.aws.iam.model.TagPolicyRequest.wrap(buildAwsValue())
}
object TagPolicyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iam.model.TagPolicyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iam.model.TagPolicyRequest =
      zio.aws.iam.model.TagPolicyRequest(
        policyArn,
        tags.map { item =>
          item.asEditable
        }
      )
    def policyArn: ArnType
    def tags: List[zio.aws.iam.model.Tag.ReadOnly]
    def getPolicyArn: ZIO[Any, Nothing, ArnType] = ZIO.succeed(policyArn)
    def getTags: ZIO[Any, Nothing, List[zio.aws.iam.model.Tag.ReadOnly]] =
      ZIO.succeed(tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iam.model.TagPolicyRequest
  ) extends zio.aws.iam.model.TagPolicyRequest.ReadOnly {
    override val policyArn: ArnType =
      zio.aws.iam.model.primitives.ArnType(impl.policyArn())
    override val tags: List[zio.aws.iam.model.Tag.ReadOnly] = impl
      .tags()
      .asScala
      .map { item =>
        zio.aws.iam.model.Tag.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.iam.model.TagPolicyRequest
  ): zio.aws.iam.model.TagPolicyRequest.ReadOnly = new Wrapper(impl)
}
