package zio.aws.iam.model
import zio.aws.iam.model.primitives.ServerCertificateNameType
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class TagServerCertificateRequest(
    serverCertificateName: ServerCertificateNameType,
    tags: Iterable[zio.aws.iam.model.Tag]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iam.model.TagServerCertificateRequest = {
    import TagServerCertificateRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iam.model.TagServerCertificateRequest
      .builder()
      .serverCertificateName(
        ServerCertificateNameType.unwrap(
          serverCertificateName
        ): java.lang.String
      )
      .tags(tags.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.iam.model.TagServerCertificateRequest.ReadOnly =
    zio.aws.iam.model.TagServerCertificateRequest.wrap(buildAwsValue())
}
object TagServerCertificateRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iam.model.TagServerCertificateRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iam.model.TagServerCertificateRequest =
      zio.aws.iam.model.TagServerCertificateRequest(
        serverCertificateName,
        tags.map { item =>
          item.asEditable
        }
      )
    def serverCertificateName: ServerCertificateNameType
    def tags: List[zio.aws.iam.model.Tag.ReadOnly]
    def getServerCertificateName: ZIO[Any, Nothing, ServerCertificateNameType] =
      ZIO.succeed(serverCertificateName)
    def getTags: ZIO[Any, Nothing, List[zio.aws.iam.model.Tag.ReadOnly]] =
      ZIO.succeed(tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iam.model.TagServerCertificateRequest
  ) extends zio.aws.iam.model.TagServerCertificateRequest.ReadOnly {
    override val serverCertificateName: ServerCertificateNameType =
      zio.aws.iam.model.primitives
        .ServerCertificateNameType(impl.serverCertificateName())
    override val tags: List[zio.aws.iam.model.Tag.ReadOnly] = impl
      .tags()
      .asScala
      .map { item =>
        zio.aws.iam.model.Tag.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.iam.model.TagServerCertificateRequest
  ): zio.aws.iam.model.TagServerCertificateRequest.ReadOnly = new Wrapper(impl)
}
