package zio.aws.iam.model
import zio.aws.iam.model.primitives.ExistingUserNameType
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class TagUserRequest(
    userName: ExistingUserNameType,
    tags: Iterable[zio.aws.iam.model.Tag]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iam.model.TagUserRequest = {
    import TagUserRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iam.model.TagUserRequest
      .builder()
      .userName(ExistingUserNameType.unwrap(userName): java.lang.String)
      .tags(tags.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.iam.model.TagUserRequest.ReadOnly =
    zio.aws.iam.model.TagUserRequest.wrap(buildAwsValue())
}
object TagUserRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iam.model.TagUserRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iam.model.TagUserRequest =
      zio.aws.iam.model.TagUserRequest(
        userName,
        tags.map { item =>
          item.asEditable
        }
      )
    def userName: ExistingUserNameType
    def tags: List[zio.aws.iam.model.Tag.ReadOnly]
    def getUserName: ZIO[Any, Nothing, ExistingUserNameType] =
      ZIO.succeed(userName)
    def getTags: ZIO[Any, Nothing, List[zio.aws.iam.model.Tag.ReadOnly]] =
      ZIO.succeed(tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iam.model.TagUserRequest
  ) extends zio.aws.iam.model.TagUserRequest.ReadOnly {
    override val userName: ExistingUserNameType =
      zio.aws.iam.model.primitives.ExistingUserNameType(impl.userName())
    override val tags: List[zio.aws.iam.model.Tag.ReadOnly] = impl
      .tags()
      .asScala
      .map { item =>
        zio.aws.iam.model.Tag.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.iam.model.TagUserRequest
  ): zio.aws.iam.model.TagUserRequest.ReadOnly = new Wrapper(impl)
}
