package zio.aws.iam.model
import zio.aws.iam.model.primitives.{TagKeyType, SerialNumberType}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class UntagMfaDeviceRequest(
    serialNumber: SerialNumberType,
    tagKeys: Iterable[TagKeyType]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iam.model.UntagMfaDeviceRequest = {
    import UntagMfaDeviceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iam.model.UntagMfaDeviceRequest
      .builder()
      .serialNumber(SerialNumberType.unwrap(serialNumber): java.lang.String)
      .tagKeys(tagKeys.map { item =>
        TagKeyType.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.iam.model.UntagMfaDeviceRequest.ReadOnly =
    zio.aws.iam.model.UntagMfaDeviceRequest.wrap(buildAwsValue())
}
object UntagMfaDeviceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iam.model.UntagMfaDeviceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iam.model.UntagMfaDeviceRequest =
      zio.aws.iam.model.UntagMfaDeviceRequest(serialNumber, tagKeys)
    def serialNumber: SerialNumberType
    def tagKeys: List[TagKeyType]
    def getSerialNumber: ZIO[Any, Nothing, SerialNumberType] =
      ZIO.succeed(serialNumber)
    def getTagKeys: ZIO[Any, Nothing, List[TagKeyType]] = ZIO.succeed(tagKeys)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iam.model.UntagMfaDeviceRequest
  ) extends zio.aws.iam.model.UntagMfaDeviceRequest.ReadOnly {
    override val serialNumber: SerialNumberType =
      zio.aws.iam.model.primitives.SerialNumberType(impl.serialNumber())
    override val tagKeys: List[TagKeyType] = impl
      .tagKeys()
      .asScala
      .map { item =>
        zio.aws.iam.model.primitives.TagKeyType(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.iam.model.UntagMfaDeviceRequest
  ): zio.aws.iam.model.UntagMfaDeviceRequest.ReadOnly = new Wrapper(impl)
}
