package zio.aws.iam.model
import zio.aws.iam.model.primitives.{TagKeyType, ArnType}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class UntagOpenIdConnectProviderRequest(
    openIDConnectProviderArn: ArnType,
    tagKeys: Iterable[TagKeyType]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iam.model.UntagOpenIdConnectProviderRequest = {
    import UntagOpenIdConnectProviderRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iam.model.UntagOpenIdConnectProviderRequest
      .builder()
      .openIDConnectProviderArn(
        ArnType.unwrap(openIDConnectProviderArn): java.lang.String
      )
      .tagKeys(tagKeys.map { item =>
        TagKeyType.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.iam.model.UntagOpenIdConnectProviderRequest.ReadOnly =
    zio.aws.iam.model.UntagOpenIdConnectProviderRequest.wrap(buildAwsValue())
}
object UntagOpenIdConnectProviderRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iam.model.UntagOpenIdConnectProviderRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iam.model.UntagOpenIdConnectProviderRequest =
      zio.aws.iam.model
        .UntagOpenIdConnectProviderRequest(openIDConnectProviderArn, tagKeys)
    def openIDConnectProviderArn: ArnType
    def tagKeys: List[TagKeyType]
    def getOpenIDConnectProviderArn: ZIO[Any, Nothing, ArnType] =
      ZIO.succeed(openIDConnectProviderArn)
    def getTagKeys: ZIO[Any, Nothing, List[TagKeyType]] = ZIO.succeed(tagKeys)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iam.model.UntagOpenIdConnectProviderRequest
  ) extends zio.aws.iam.model.UntagOpenIdConnectProviderRequest.ReadOnly {
    override val openIDConnectProviderArn: ArnType =
      zio.aws.iam.model.primitives.ArnType(impl.openIDConnectProviderArn())
    override val tagKeys: List[TagKeyType] = impl
      .tagKeys()
      .asScala
      .map { item =>
        zio.aws.iam.model.primitives.TagKeyType(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.iam.model.UntagOpenIdConnectProviderRequest
  ): zio.aws.iam.model.UntagOpenIdConnectProviderRequest.ReadOnly = new Wrapper(
    impl
  )
}
