package zio.aws.iam.model
import zio.aws.iam.model.primitives.{TagKeyType, ArnType}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class UntagPolicyRequest(
    policyArn: ArnType,
    tagKeys: Iterable[TagKeyType]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iam.model.UntagPolicyRequest = {
    import UntagPolicyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iam.model.UntagPolicyRequest
      .builder()
      .policyArn(ArnType.unwrap(policyArn): java.lang.String)
      .tagKeys(tagKeys.map { item =>
        TagKeyType.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.iam.model.UntagPolicyRequest.ReadOnly =
    zio.aws.iam.model.UntagPolicyRequest.wrap(buildAwsValue())
}
object UntagPolicyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iam.model.UntagPolicyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iam.model.UntagPolicyRequest =
      zio.aws.iam.model.UntagPolicyRequest(policyArn, tagKeys)
    def policyArn: ArnType
    def tagKeys: List[TagKeyType]
    def getPolicyArn: ZIO[Any, Nothing, ArnType] = ZIO.succeed(policyArn)
    def getTagKeys: ZIO[Any, Nothing, List[TagKeyType]] = ZIO.succeed(tagKeys)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iam.model.UntagPolicyRequest
  ) extends zio.aws.iam.model.UntagPolicyRequest.ReadOnly {
    override val policyArn: ArnType =
      zio.aws.iam.model.primitives.ArnType(impl.policyArn())
    override val tagKeys: List[TagKeyType] = impl
      .tagKeys()
      .asScala
      .map { item =>
        zio.aws.iam.model.primitives.TagKeyType(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.iam.model.UntagPolicyRequest
  ): zio.aws.iam.model.UntagPolicyRequest.ReadOnly = new Wrapper(impl)
}
