package zio.aws.iam.model
import zio.aws.iam.model.primitives.{TagKeyType, ArnType}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class UntagSamlProviderRequest(
    samlProviderArn: ArnType,
    tagKeys: Iterable[TagKeyType]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iam.model.UntagSamlProviderRequest = {
    import UntagSamlProviderRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iam.model.UntagSamlProviderRequest
      .builder()
      .samlProviderArn(ArnType.unwrap(samlProviderArn): java.lang.String)
      .tagKeys(tagKeys.map { item =>
        TagKeyType.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.iam.model.UntagSamlProviderRequest.ReadOnly =
    zio.aws.iam.model.UntagSamlProviderRequest.wrap(buildAwsValue())
}
object UntagSamlProviderRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iam.model.UntagSamlProviderRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iam.model.UntagSamlProviderRequest =
      zio.aws.iam.model.UntagSamlProviderRequest(samlProviderArn, tagKeys)
    def samlProviderArn: ArnType
    def tagKeys: List[TagKeyType]
    def getSamlProviderArn: ZIO[Any, Nothing, ArnType] =
      ZIO.succeed(samlProviderArn)
    def getTagKeys: ZIO[Any, Nothing, List[TagKeyType]] = ZIO.succeed(tagKeys)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iam.model.UntagSamlProviderRequest
  ) extends zio.aws.iam.model.UntagSamlProviderRequest.ReadOnly {
    override val samlProviderArn: ArnType =
      zio.aws.iam.model.primitives.ArnType(impl.samlProviderArn())
    override val tagKeys: List[TagKeyType] = impl
      .tagKeys()
      .asScala
      .map { item =>
        zio.aws.iam.model.primitives.TagKeyType(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.iam.model.UntagSamlProviderRequest
  ): zio.aws.iam.model.UntagSamlProviderRequest.ReadOnly = new Wrapper(impl)
}
