package zio.aws.iam.model
import zio.aws.iam.model.primitives.{TagKeyType, ExistingUserNameType}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class UntagUserRequest(
    userName: ExistingUserNameType,
    tagKeys: Iterable[TagKeyType]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iam.model.UntagUserRequest = {
    import UntagUserRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iam.model.UntagUserRequest
      .builder()
      .userName(ExistingUserNameType.unwrap(userName): java.lang.String)
      .tagKeys(tagKeys.map { item =>
        TagKeyType.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.iam.model.UntagUserRequest.ReadOnly =
    zio.aws.iam.model.UntagUserRequest.wrap(buildAwsValue())
}
object UntagUserRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iam.model.UntagUserRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iam.model.UntagUserRequest =
      zio.aws.iam.model.UntagUserRequest(userName, tagKeys)
    def userName: ExistingUserNameType
    def tagKeys: List[TagKeyType]
    def getUserName: ZIO[Any, Nothing, ExistingUserNameType] =
      ZIO.succeed(userName)
    def getTagKeys: ZIO[Any, Nothing, List[TagKeyType]] = ZIO.succeed(tagKeys)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iam.model.UntagUserRequest
  ) extends zio.aws.iam.model.UntagUserRequest.ReadOnly {
    override val userName: ExistingUserNameType =
      zio.aws.iam.model.primitives.ExistingUserNameType(impl.userName())
    override val tagKeys: List[TagKeyType] = impl
      .tagKeys()
      .asScala
      .map { item =>
        zio.aws.iam.model.primitives.TagKeyType(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.iam.model.UntagUserRequest
  ): zio.aws.iam.model.UntagUserRequest.ReadOnly = new Wrapper(impl)
}
