package zio.aws.iam.model
import zio.aws.iam.model.primitives.{
  BooleanObjectType,
  PasswordType,
  UserNameType
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UpdateLoginProfileRequest(
    userName: UserNameType,
    password: Optional[PasswordType] = Optional.Absent,
    passwordResetRequired: Optional[BooleanObjectType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iam.model.UpdateLoginProfileRequest = {
    import UpdateLoginProfileRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iam.model.UpdateLoginProfileRequest
      .builder()
      .userName(UserNameType.unwrap(userName): java.lang.String)
      .optionallyWith(
        password.map(value => PasswordType.unwrap(value): java.lang.String)
      )(_.password)
      .optionallyWith(
        passwordResetRequired.map(value =>
          BooleanObjectType.unwrap(value): java.lang.Boolean
        )
      )(_.passwordResetRequired)
      .build()
  }
  def asReadOnly: zio.aws.iam.model.UpdateLoginProfileRequest.ReadOnly =
    zio.aws.iam.model.UpdateLoginProfileRequest.wrap(buildAwsValue())
}
object UpdateLoginProfileRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iam.model.UpdateLoginProfileRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iam.model.UpdateLoginProfileRequest =
      zio.aws.iam.model.UpdateLoginProfileRequest(
        userName,
        password.map(value => value),
        passwordResetRequired.map(value => value)
      )
    def userName: UserNameType
    def password: Optional[PasswordType]
    def passwordResetRequired: Optional[BooleanObjectType]
    def getUserName: ZIO[Any, Nothing, UserNameType] = ZIO.succeed(userName)
    def getPassword: ZIO[Any, AwsError, PasswordType] =
      AwsError.unwrapOptionField("password", password)
    def getPasswordResetRequired: ZIO[Any, AwsError, BooleanObjectType] =
      AwsError.unwrapOptionField("passwordResetRequired", passwordResetRequired)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iam.model.UpdateLoginProfileRequest
  ) extends zio.aws.iam.model.UpdateLoginProfileRequest.ReadOnly {
    override val userName: UserNameType =
      zio.aws.iam.model.primitives.UserNameType(impl.userName())
    override val password: Optional[PasswordType] = zio.aws.core.internal
      .optionalFromNullable(impl.password())
      .map(value => zio.aws.iam.model.primitives.PasswordType(value))
    override val passwordResetRequired: Optional[BooleanObjectType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.passwordResetRequired())
        .map(value => zio.aws.iam.model.primitives.BooleanObjectType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iam.model.UpdateLoginProfileRequest
  ): zio.aws.iam.model.UpdateLoginProfileRequest.ReadOnly = new Wrapper(impl)
}
