package zio.aws.iam.model
import zio.aws.iam.model.primitives.{ThumbprintType, ArnType}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class UpdateOpenIdConnectProviderThumbprintRequest(
    openIDConnectProviderArn: ArnType,
    thumbprintList: Iterable[ThumbprintType]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iam.model.UpdateOpenIdConnectProviderThumbprintRequest = {
    import UpdateOpenIdConnectProviderThumbprintRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iam.model.UpdateOpenIdConnectProviderThumbprintRequest
      .builder()
      .openIDConnectProviderArn(
        ArnType.unwrap(openIDConnectProviderArn): java.lang.String
      )
      .thumbprintList(thumbprintList.map { item =>
        ThumbprintType.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.iam.model.UpdateOpenIdConnectProviderThumbprintRequest.ReadOnly =
    zio.aws.iam.model.UpdateOpenIdConnectProviderThumbprintRequest
      .wrap(buildAwsValue())
}
object UpdateOpenIdConnectProviderThumbprintRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iam.model.UpdateOpenIdConnectProviderThumbprintRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.iam.model.UpdateOpenIdConnectProviderThumbprintRequest =
      zio.aws.iam.model.UpdateOpenIdConnectProviderThumbprintRequest(
        openIDConnectProviderArn,
        thumbprintList
      )
    def openIDConnectProviderArn: ArnType
    def thumbprintList: List[ThumbprintType]
    def getOpenIDConnectProviderArn: ZIO[Any, Nothing, ArnType] =
      ZIO.succeed(openIDConnectProviderArn)
    def getThumbprintList: ZIO[Any, Nothing, List[ThumbprintType]] =
      ZIO.succeed(thumbprintList)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iam.model.UpdateOpenIdConnectProviderThumbprintRequest
  ) extends zio.aws.iam.model.UpdateOpenIdConnectProviderThumbprintRequest.ReadOnly {
    override val openIDConnectProviderArn: ArnType =
      zio.aws.iam.model.primitives.ArnType(impl.openIDConnectProviderArn())
    override val thumbprintList: List[ThumbprintType] = impl
      .thumbprintList()
      .asScala
      .map { item =>
        zio.aws.iam.model.primitives.ThumbprintType(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.iam.model.UpdateOpenIdConnectProviderThumbprintRequest
  ): zio.aws.iam.model.UpdateOpenIdConnectProviderThumbprintRequest.ReadOnly =
    new Wrapper(impl)
}
