package zio.aws.iam.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.iam.model.primitives.{
  RoleMaxSessionDurationType,
  RoleDescriptionType,
  RoleNameType
}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class UpdateRoleRequest(
    roleName: RoleNameType,
    description: Optional[RoleDescriptionType] = Optional.Absent,
    maxSessionDuration: Optional[RoleMaxSessionDurationType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iam.model.UpdateRoleRequest = {
    import UpdateRoleRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iam.model.UpdateRoleRequest
      .builder()
      .roleName(RoleNameType.unwrap(roleName): java.lang.String)
      .optionallyWith(
        description.map(value =>
          RoleDescriptionType.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        maxSessionDuration.map(value =>
          RoleMaxSessionDurationType.unwrap(value): Integer
        )
      )(_.maxSessionDuration)
      .build()
  }
  def asReadOnly: zio.aws.iam.model.UpdateRoleRequest.ReadOnly =
    zio.aws.iam.model.UpdateRoleRequest.wrap(buildAwsValue())
}
object UpdateRoleRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iam.model.UpdateRoleRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iam.model.UpdateRoleRequest =
      zio.aws.iam.model.UpdateRoleRequest(
        roleName,
        description.map(value => value),
        maxSessionDuration.map(value => value)
      )
    def roleName: RoleNameType
    def description: Optional[RoleDescriptionType]
    def maxSessionDuration: Optional[RoleMaxSessionDurationType]
    def getRoleName: ZIO[Any, Nothing, RoleNameType] = ZIO.succeed(roleName)
    def getDescription: ZIO[Any, AwsError, RoleDescriptionType] =
      AwsError.unwrapOptionField("description", description)
    def getMaxSessionDuration: ZIO[Any, AwsError, RoleMaxSessionDurationType] =
      AwsError.unwrapOptionField("maxSessionDuration", maxSessionDuration)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iam.model.UpdateRoleRequest
  ) extends zio.aws.iam.model.UpdateRoleRequest.ReadOnly {
    override val roleName: RoleNameType =
      zio.aws.iam.model.primitives.RoleNameType(impl.roleName())
    override val description: Optional[RoleDescriptionType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value => zio.aws.iam.model.primitives.RoleDescriptionType(value))
    override val maxSessionDuration: Optional[RoleMaxSessionDurationType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxSessionDuration())
        .map(value =>
          zio.aws.iam.model.primitives.RoleMaxSessionDurationType(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iam.model.UpdateRoleRequest
  ): zio.aws.iam.model.UpdateRoleRequest.ReadOnly = new Wrapper(impl)
}
