package zio.aws.iam
import zio.aws.iam.model.GetServiceLinkedRoleDeletionStatusResponse.ReadOnly
import zio.mock.{Proxy, Mock}
import zio.aws.core.AwsError
import zio.aws.core.aspects.AwsCallAspect
import zio.{IO, ZEnvironment, URLayer}
import zio.aws.iam.model.{
  DeleteUserRequest,
  GetPolicyVersionRequest,
  GenerateServiceLastAccessedDetailsRequest,
  TagSamlProviderRequest,
  ListAttachedUserPoliciesRequest,
  UpdateAccessKeyRequest,
  GetContextKeysForCustomPolicyRequest,
  DeleteVirtualMfaDeviceRequest,
  SetSecurityTokenServicePreferencesRequest,
  ListVirtualMfaDevicesRequest,
  ChangePasswordRequest,
  GetServerCertificateRequest,
  ListInstanceProfilesForRoleRequest,
  ListMfaDevicesRequest,
  DeleteServiceLinkedRoleRequest,
  GetAccessKeyLastUsedRequest,
  ListInstanceProfilesRequest,
  ListPoliciesGrantingServiceAccessRequest,
  ListMfaDeviceTagsRequest,
  GetServiceLastAccessedDetailsRequest,
  ListSigningCertificatesRequest,
  ListSamlProvidersRequest,
  TagInstanceProfileRequest,
  UntagRoleRequest,
  PutRolePermissionsBoundaryRequest,
  GetRolePolicyRequest,
  ListServerCertificatesRequest,
  ListUserTagsRequest,
  DeleteRolePermissionsBoundaryRequest,
  CreateRoleRequest,
  DeleteSshPublicKeyRequest,
  UpdateServerCertificateRequest,
  GetInstanceProfileRequest,
  CreateInstanceProfileRequest,
  ListRoleTagsRequest,
  ListPoliciesRequest,
  ListGroupPoliciesRequest,
  DeleteServerCertificateRequest,
  GetServiceLastAccessedDetailsWithEntitiesRequest,
  ListSamlProviderTagsRequest,
  DeleteAccessKeyRequest,
  GetContextKeysForPrincipalPolicyRequest,
  GetGroupRequest,
  DeleteGroupPolicyRequest,
  DetachRolePolicyRequest,
  UpdateRoleDescriptionRequest,
  ListUsersRequest,
  CreateAccountAliasRequest,
  ListServerCertificateTagsRequest,
  UpdateGroupRequest,
  AddClientIdToOpenIdConnectProviderRequest,
  CreateVirtualMfaDeviceRequest,
  PutGroupPolicyRequest,
  DetachGroupPolicyRequest,
  UpdateSigningCertificateRequest,
  ListOpenIdConnectProvidersRequest,
  ListUserPoliciesRequest,
  UpdateAccountPasswordPolicyRequest,
  UpdateServiceSpecificCredentialRequest,
  DeleteUserPermissionsBoundaryRequest,
  CreateServiceLinkedRoleRequest,
  ListAttachedRolePoliciesRequest,
  ListAccessKeysRequest,
  GetLoginProfileRequest,
  RemoveClientIdFromOpenIdConnectProviderRequest,
  UpdateSamlProviderRequest,
  GetUserPolicyRequest,
  DeactivateMfaDeviceRequest,
  PutUserPermissionsBoundaryRequest,
  RemoveRoleFromInstanceProfileRequest,
  GetSamlProviderRequest,
  UpdateLoginProfileRequest,
  ListSshPublicKeysRequest,
  UntagInstanceProfileRequest,
  SimulateCustomPolicyRequest,
  ListGroupsForUserRequest,
  DeleteGroupRequest,
  AttachGroupPolicyRequest,
  TagUserRequest,
  CreateOpenIdConnectProviderRequest,
  DeleteInstanceProfileRequest,
  GetOrganizationsAccessReportRequest,
  CreateSamlProviderRequest,
  GetSshPublicKeyRequest,
  UntagPolicyRequest,
  ListGroupsRequest,
  ListPolicyTagsRequest,
  AttachUserPolicyRequest,
  DeleteServiceSpecificCredentialRequest,
  AddRoleToInstanceProfileRequest,
  TagOpenIdConnectProviderRequest,
  DeleteSigningCertificateRequest,
  GetServiceLinkedRoleDeletionStatusRequest,
  DeletePolicyVersionRequest,
  TagMfaDeviceRequest,
  GenerateOrganizationsAccessReportRequest,
  ListEntitiesForPolicyRequest,
  EnableMfaDeviceRequest,
  CreateUserRequest,
  ListRolesRequest,
  TagServerCertificateRequest,
  UntagUserRequest,
  UntagServerCertificateRequest,
  SetDefaultPolicyVersionRequest,
  DetachUserPolicyRequest,
  UpdateRoleRequest,
  UntagSamlProviderRequest,
  PutUserPolicyRequest,
  DeleteRolePolicyRequest,
  GetGroupPolicyRequest,
  ListInstanceProfileTagsRequest,
  GetUserRequest,
  CreateServiceSpecificCredentialRequest,
  UpdateOpenIdConnectProviderThumbprintRequest,
  AddUserToGroupRequest,
  ResetServiceSpecificCredentialRequest,
  ListPolicyVersionsRequest,
  GetPolicyRequest,
  UploadSigningCertificateRequest,
  CreatePolicyVersionRequest,
  DeleteSamlProviderRequest,
  UploadSshPublicKeyRequest,
  DeleteLoginProfileRequest,
  CreateLoginProfileRequest,
  ListAttachedGroupPoliciesRequest,
  TagRoleRequest,
  CreateGroupRequest,
  PutRolePolicyRequest,
  ListOpenIdConnectProviderTagsRequest,
  UpdateUserRequest,
  ListServiceSpecificCredentialsRequest,
  ListAccountAliasesRequest,
  UpdateSshPublicKeyRequest,
  DeleteRoleRequest,
  RemoveUserFromGroupRequest,
  CreateAccessKeyRequest,
  GetRoleRequest,
  GetAccountAuthorizationDetailsRequest,
  UploadServerCertificateRequest,
  ListRolePoliciesRequest,
  UntagMfaDeviceRequest,
  GetOpenIdConnectProviderRequest,
  SimulatePrincipalPolicyRequest,
  DeletePolicyRequest,
  TagPolicyRequest,
  UpdateAssumeRolePolicyRequest,
  DeleteOpenIdConnectProviderRequest,
  ResyncMfaDeviceRequest,
  CreatePolicyRequest,
  DeleteAccountAliasRequest,
  UntagOpenIdConnectProviderRequest,
  AttachRolePolicyRequest,
  DeleteUserPolicyRequest
}
import zio.aws.iam.model.primitives.{AccountAliasType, PolicyNameType}
import zio.stream.ZStream
import software.amazon.awssdk.services.iam.IamAsyncClient
object IamMock extends Mock[Iam] {
  object GetOpenIDConnectProvider
      extends Effect[
        GetOpenIdConnectProviderRequest,
        AwsError,
        zio.aws.iam.model.GetOpenIdConnectProviderResponse.ReadOnly
      ]
  object ListUserPolicies
      extends Stream[ListUserPoliciesRequest, AwsError, PolicyNameType]
  object ListUserPoliciesPaginated
      extends Effect[
        ListUserPoliciesRequest,
        AwsError,
        zio.aws.iam.model.ListUserPoliciesResponse.ReadOnly
      ]
  object DeleteAccountAlias
      extends Effect[DeleteAccountAliasRequest, AwsError, Unit]
  object DeleteRolePolicy
      extends Effect[DeleteRolePolicyRequest, AwsError, Unit]
  object UploadSSHPublicKey
      extends Effect[
        UploadSshPublicKeyRequest,
        AwsError,
        zio.aws.iam.model.UploadSshPublicKeyResponse.ReadOnly
      ]
  object DeleteOpenIDConnectProvider
      extends Effect[DeleteOpenIdConnectProviderRequest, AwsError, Unit]
  object ListUsers
      extends Stream[
        ListUsersRequest,
        AwsError,
        zio.aws.iam.model.User.ReadOnly
      ]
  object ListUsersPaginated
      extends Effect[
        ListUsersRequest,
        AwsError,
        zio.aws.iam.model.ListUsersResponse.ReadOnly
      ]
  object TagServerCertificate
      extends Effect[TagServerCertificateRequest, AwsError, Unit]
  object TagRole extends Effect[TagRoleRequest, AwsError, Unit]
  object UpdateUser extends Effect[UpdateUserRequest, AwsError, Unit]
  object UpdateSAMLProvider
      extends Effect[
        UpdateSamlProviderRequest,
        AwsError,
        zio.aws.iam.model.UpdateSamlProviderResponse.ReadOnly
      ]
  object UntagInstanceProfile
      extends Effect[UntagInstanceProfileRequest, AwsError, Unit]
  object CreateSAMLProvider
      extends Effect[
        CreateSamlProviderRequest,
        AwsError,
        zio.aws.iam.model.CreateSamlProviderResponse.ReadOnly
      ]
  object EnableMFADevice extends Effect[EnableMfaDeviceRequest, AwsError, Unit]
  object RemoveClientIDFromOpenIDConnectProvider
      extends Effect[
        RemoveClientIdFromOpenIdConnectProviderRequest,
        AwsError,
        Unit
      ]
  object AddClientIDToOpenIDConnectProvider
      extends Effect[AddClientIdToOpenIdConnectProviderRequest, AwsError, Unit]
  object ListSSHPublicKeys
      extends Stream[
        ListSshPublicKeysRequest,
        AwsError,
        zio.aws.iam.model.SSHPublicKeyMetadata.ReadOnly
      ]
  object ListSSHPublicKeysPaginated
      extends Effect[
        ListSshPublicKeysRequest,
        AwsError,
        zio.aws.iam.model.ListSshPublicKeysResponse.ReadOnly
      ]
  object GetLoginProfile
      extends Effect[
        GetLoginProfileRequest,
        AwsError,
        zio.aws.iam.model.GetLoginProfileResponse.ReadOnly
      ]
  object UploadSigningCertificate
      extends Effect[
        UploadSigningCertificateRequest,
        AwsError,
        zio.aws.iam.model.UploadSigningCertificateResponse.ReadOnly
      ]
  object DetachRolePolicy
      extends Effect[DetachRolePolicyRequest, AwsError, Unit]
  object ResyncMFADevice extends Effect[ResyncMfaDeviceRequest, AwsError, Unit]
  object ListServiceSpecificCredentials
      extends Effect[
        ListServiceSpecificCredentialsRequest,
        AwsError,
        zio.aws.iam.model.ListServiceSpecificCredentialsResponse.ReadOnly
      ]
  object ListAttachedRolePolicies
      extends Stream[
        ListAttachedRolePoliciesRequest,
        AwsError,
        zio.aws.iam.model.AttachedPolicy.ReadOnly
      ]
  object ListAttachedRolePoliciesPaginated
      extends Effect[
        ListAttachedRolePoliciesRequest,
        AwsError,
        zio.aws.iam.model.ListAttachedRolePoliciesResponse.ReadOnly
      ]
  object GetSSHPublicKey
      extends Effect[
        GetSshPublicKeyRequest,
        AwsError,
        zio.aws.iam.model.GetSshPublicKeyResponse.ReadOnly
      ]
  object UntagSAMLProvider
      extends Effect[UntagSamlProviderRequest, AwsError, Unit]
  object SimulateCustomPolicy
      extends Stream[
        SimulateCustomPolicyRequest,
        AwsError,
        zio.aws.iam.model.EvaluationResult.ReadOnly
      ]
  object SimulateCustomPolicyPaginated
      extends Effect[
        SimulateCustomPolicyRequest,
        AwsError,
        zio.aws.iam.model.SimulateCustomPolicyResponse.ReadOnly
      ]
  object DeleteAccessKey extends Effect[DeleteAccessKeyRequest, AwsError, Unit]
  object GetServiceLastAccessedDetails
      extends Effect[
        GetServiceLastAccessedDetailsRequest,
        AwsError,
        zio.aws.iam.model.GetServiceLastAccessedDetailsResponse.ReadOnly
      ]
  object DeleteUserPolicy
      extends Effect[DeleteUserPolicyRequest, AwsError, Unit]
  object UntagUser extends Effect[UntagUserRequest, AwsError, Unit]
  object CreateServiceSpecificCredential
      extends Effect[
        CreateServiceSpecificCredentialRequest,
        AwsError,
        zio.aws.iam.model.CreateServiceSpecificCredentialResponse.ReadOnly
      ]
  object ListSAMLProviders
      extends Effect[
        ListSamlProvidersRequest,
        AwsError,
        zio.aws.iam.model.ListSamlProvidersResponse.ReadOnly
      ]
  object ListPoliciesGrantingServiceAccess
      extends Effect[
        ListPoliciesGrantingServiceAccessRequest,
        AwsError,
        zio.aws.iam.model.ListPoliciesGrantingServiceAccessResponse.ReadOnly
      ]
  object GetGroupPolicy
      extends Effect[
        GetGroupPolicyRequest,
        AwsError,
        zio.aws.iam.model.GetGroupPolicyResponse.ReadOnly
      ]
  object UploadServerCertificate
      extends Effect[
        UploadServerCertificateRequest,
        AwsError,
        zio.aws.iam.model.UploadServerCertificateResponse.ReadOnly
      ]
  object UpdateServerCertificate
      extends Effect[UpdateServerCertificateRequest, AwsError, Unit]
  object DeleteGroup extends Effect[DeleteGroupRequest, AwsError, Unit]
  object RemoveRoleFromInstanceProfile
      extends Effect[RemoveRoleFromInstanceProfileRequest, AwsError, Unit]
  object CreateRole
      extends Effect[
        CreateRoleRequest,
        AwsError,
        zio.aws.iam.model.CreateRoleResponse.ReadOnly
      ]
  object GetAccountSummary
      extends Effect[
        Unit,
        AwsError,
        zio.aws.iam.model.GetAccountSummaryResponse.ReadOnly
      ]
  object ChangePassword extends Effect[ChangePasswordRequest, AwsError, Unit]
  object ListRolePolicies
      extends Stream[ListRolePoliciesRequest, AwsError, PolicyNameType]
  object ListRolePoliciesPaginated
      extends Effect[
        ListRolePoliciesRequest,
        AwsError,
        zio.aws.iam.model.ListRolePoliciesResponse.ReadOnly
      ]
  object DetachGroupPolicy
      extends Effect[DetachGroupPolicyRequest, AwsError, Unit]
  object ListGroupsForUser
      extends Stream[
        ListGroupsForUserRequest,
        AwsError,
        zio.aws.iam.model.Group.ReadOnly
      ]
  object ListGroupsForUserPaginated
      extends Effect[
        ListGroupsForUserRequest,
        AwsError,
        zio.aws.iam.model.ListGroupsForUserResponse.ReadOnly
      ]
  object DeleteVirtualMFADevice
      extends Effect[DeleteVirtualMfaDeviceRequest, AwsError, Unit]
  object ListAttachedGroupPolicies
      extends Stream[
        ListAttachedGroupPoliciesRequest,
        AwsError,
        zio.aws.iam.model.AttachedPolicy.ReadOnly
      ]
  object ListAttachedGroupPoliciesPaginated
      extends Effect[
        ListAttachedGroupPoliciesRequest,
        AwsError,
        zio.aws.iam.model.ListAttachedGroupPoliciesResponse.ReadOnly
      ]
  object GetUser
      extends Effect[
        GetUserRequest,
        AwsError,
        zio.aws.iam.model.GetUserResponse.ReadOnly
      ]
  object DeleteAccountPasswordPolicy extends Effect[Unit, AwsError, Unit]
  object GetContextKeysForPrincipalPolicy
      extends Effect[
        GetContextKeysForPrincipalPolicyRequest,
        AwsError,
        zio.aws.iam.model.GetContextKeysForPrincipalPolicyResponse.ReadOnly
      ]
  object ListGroups
      extends Stream[
        ListGroupsRequest,
        AwsError,
        zio.aws.iam.model.Group.ReadOnly
      ]
  object ListGroupsPaginated
      extends Effect[
        ListGroupsRequest,
        AwsError,
        zio.aws.iam.model.ListGroupsResponse.ReadOnly
      ]
  object ListPolicyVersions
      extends Stream[
        ListPolicyVersionsRequest,
        AwsError,
        zio.aws.iam.model.PolicyVersion.ReadOnly
      ]
  object ListPolicyVersionsPaginated
      extends Effect[
        ListPolicyVersionsRequest,
        AwsError,
        zio.aws.iam.model.ListPolicyVersionsResponse.ReadOnly
      ]
  object GetRolePolicy
      extends Effect[
        GetRolePolicyRequest,
        AwsError,
        zio.aws.iam.model.GetRolePolicyResponse.ReadOnly
      ]
  object TagOpenIDConnectProvider
      extends Effect[TagOpenIdConnectProviderRequest, AwsError, Unit]
  object DeleteRole extends Effect[DeleteRoleRequest, AwsError, Unit]
  object UpdateOpenIDConnectProviderThumbprint
      extends Effect[
        UpdateOpenIdConnectProviderThumbprintRequest,
        AwsError,
        Unit
      ]
  object UntagPolicy extends Effect[UntagPolicyRequest, AwsError, Unit]
  object DetachUserPolicy
      extends Effect[DetachUserPolicyRequest, AwsError, Unit]
  object ListEntitiesForPolicy
      extends Stream[
        ListEntitiesForPolicyRequest,
        AwsError,
        zio.aws.iam.model.PolicyGroup.ReadOnly
      ]
  object ListEntitiesForPolicyPaginated
      extends Effect[
        ListEntitiesForPolicyRequest,
        AwsError,
        zio.aws.iam.model.ListEntitiesForPolicyResponse.ReadOnly
      ]
  object ListMFADeviceTags
      extends Effect[
        ListMfaDeviceTagsRequest,
        AwsError,
        zio.aws.iam.model.ListMfaDeviceTagsResponse.ReadOnly
      ]
  object DeleteSSHPublicKey
      extends Effect[DeleteSshPublicKeyRequest, AwsError, Unit]
  object CreateUser
      extends Effect[
        CreateUserRequest,
        AwsError,
        zio.aws.iam.model.CreateUserResponse.ReadOnly
      ]
  object DeleteSigningCertificate
      extends Effect[DeleteSigningCertificateRequest, AwsError, Unit]
  object SetDefaultPolicyVersion
      extends Effect[SetDefaultPolicyVersionRequest, AwsError, Unit]
  object UpdateRole
      extends Effect[
        UpdateRoleRequest,
        AwsError,
        zio.aws.iam.model.UpdateRoleResponse.ReadOnly
      ]
  object ListSAMLProviderTags
      extends Effect[
        ListSamlProviderTagsRequest,
        AwsError,
        zio.aws.iam.model.ListSamlProviderTagsResponse.ReadOnly
      ]
  object CreateServiceLinkedRole
      extends Effect[
        CreateServiceLinkedRoleRequest,
        AwsError,
        zio.aws.iam.model.CreateServiceLinkedRoleResponse.ReadOnly
      ]
  object AddUserToGroup extends Effect[AddUserToGroupRequest, AwsError, Unit]
  object DeleteServiceSpecificCredential
      extends Effect[DeleteServiceSpecificCredentialRequest, AwsError, Unit]
  object PutRolePermissionsBoundary
      extends Effect[PutRolePermissionsBoundaryRequest, AwsError, Unit]
  object DeleteUserPermissionsBoundary
      extends Effect[DeleteUserPermissionsBoundaryRequest, AwsError, Unit]
  object PutRolePolicy extends Effect[PutRolePolicyRequest, AwsError, Unit]
  object ListSigningCertificates
      extends Stream[
        ListSigningCertificatesRequest,
        AwsError,
        zio.aws.iam.model.SigningCertificate.ReadOnly
      ]
  object ListSigningCertificatesPaginated
      extends Effect[
        ListSigningCertificatesRequest,
        AwsError,
        zio.aws.iam.model.ListSigningCertificatesResponse.ReadOnly
      ]
  object CreateAccessKey
      extends Effect[
        CreateAccessKeyRequest,
        AwsError,
        zio.aws.iam.model.CreateAccessKeyResponse.ReadOnly
      ]
  object UntagOpenIDConnectProvider
      extends Effect[UntagOpenIdConnectProviderRequest, AwsError, Unit]
  object TagInstanceProfile
      extends Effect[TagInstanceProfileRequest, AwsError, Unit]
  object ListRoles
      extends Stream[
        ListRolesRequest,
        AwsError,
        zio.aws.iam.model.Role.ReadOnly
      ]
  object ListRolesPaginated
      extends Effect[
        ListRolesRequest,
        AwsError,
        zio.aws.iam.model.ListRolesResponse.ReadOnly
      ]
  object ListPolicies
      extends Stream[
        ListPoliciesRequest,
        AwsError,
        zio.aws.iam.model.Policy.ReadOnly
      ]
  object ListPoliciesPaginated
      extends Effect[
        ListPoliciesRequest,
        AwsError,
        zio.aws.iam.model.ListPoliciesResponse.ReadOnly
      ]
  object PutGroupPolicy extends Effect[PutGroupPolicyRequest, AwsError, Unit]
  object CreateLoginProfile
      extends Effect[
        CreateLoginProfileRequest,
        AwsError,
        zio.aws.iam.model.CreateLoginProfileResponse.ReadOnly
      ]
  object DeleteGroupPolicy
      extends Effect[DeleteGroupPolicyRequest, AwsError, Unit]
  object CreateOpenIDConnectProvider
      extends Effect[
        CreateOpenIdConnectProviderRequest,
        AwsError,
        zio.aws.iam.model.CreateOpenIdConnectProviderResponse.ReadOnly
      ]
  object GenerateOrganizationsAccessReport
      extends Effect[
        GenerateOrganizationsAccessReportRequest,
        AwsError,
        zio.aws.iam.model.GenerateOrganizationsAccessReportResponse.ReadOnly
      ]
  object GenerateServiceLastAccessedDetails
      extends Effect[
        GenerateServiceLastAccessedDetailsRequest,
        AwsError,
        zio.aws.iam.model.GenerateServiceLastAccessedDetailsResponse.ReadOnly
      ]
  object GetUserPolicy
      extends Effect[
        GetUserPolicyRequest,
        AwsError,
        zio.aws.iam.model.GetUserPolicyResponse.ReadOnly
      ]
  object GetAccountPasswordPolicy
      extends Effect[
        Unit,
        AwsError,
        zio.aws.iam.model.GetAccountPasswordPolicyResponse.ReadOnly
      ]
  object UpdateAccessKey extends Effect[UpdateAccessKeyRequest, AwsError, Unit]
  object DeletePolicyVersion
      extends Effect[DeletePolicyVersionRequest, AwsError, Unit]
  object CreateVirtualMFADevice
      extends Effect[
        CreateVirtualMfaDeviceRequest,
        AwsError,
        zio.aws.iam.model.CreateVirtualMfaDeviceResponse.ReadOnly
      ]
  object RemoveUserFromGroup
      extends Effect[RemoveUserFromGroupRequest, AwsError, Unit]
  object DeleteServerCertificate
      extends Effect[DeleteServerCertificateRequest, AwsError, Unit]
  object UntagRole extends Effect[UntagRoleRequest, AwsError, Unit]
  object AddRoleToInstanceProfile
      extends Effect[AddRoleToInstanceProfileRequest, AwsError, Unit]
  object PutUserPermissionsBoundary
      extends Effect[PutUserPermissionsBoundaryRequest, AwsError, Unit]
  object ResetServiceSpecificCredential
      extends Effect[
        ResetServiceSpecificCredentialRequest,
        AwsError,
        zio.aws.iam.model.ResetServiceSpecificCredentialResponse.ReadOnly
      ]
  object ListVirtualMFADevices
      extends Stream[
        ListVirtualMfaDevicesRequest,
        AwsError,
        zio.aws.iam.model.VirtualMFADevice.ReadOnly
      ]
  object ListVirtualMFADevicesPaginated
      extends Effect[
        ListVirtualMfaDevicesRequest,
        AwsError,
        zio.aws.iam.model.ListVirtualMfaDevicesResponse.ReadOnly
      ]
  object DeleteLoginProfile
      extends Effect[DeleteLoginProfileRequest, AwsError, Unit]
  object ListGroupPolicies
      extends Stream[ListGroupPoliciesRequest, AwsError, PolicyNameType]
  object ListGroupPoliciesPaginated
      extends Effect[
        ListGroupPoliciesRequest,
        AwsError,
        zio.aws.iam.model.ListGroupPoliciesResponse.ReadOnly
      ]
  object DeleteInstanceProfile
      extends Effect[DeleteInstanceProfileRequest, AwsError, Unit]
  object CreateGroup
      extends Effect[
        CreateGroupRequest,
        AwsError,
        zio.aws.iam.model.CreateGroupResponse.ReadOnly
      ]
  object UntagMFADevice extends Effect[UntagMfaDeviceRequest, AwsError, Unit]
  object CreateAccountAlias
      extends Effect[CreateAccountAliasRequest, AwsError, Unit]
  object AttachGroupPolicy
      extends Effect[AttachGroupPolicyRequest, AwsError, Unit]
  object SetSecurityTokenServicePreferences
      extends Effect[SetSecurityTokenServicePreferencesRequest, AwsError, Unit]
  object PutUserPolicy extends Effect[PutUserPolicyRequest, AwsError, Unit]
  object ListAttachedUserPolicies
      extends Stream[
        ListAttachedUserPoliciesRequest,
        AwsError,
        zio.aws.iam.model.AttachedPolicy.ReadOnly
      ]
  object ListAttachedUserPoliciesPaginated
      extends Effect[
        ListAttachedUserPoliciesRequest,
        AwsError,
        zio.aws.iam.model.ListAttachedUserPoliciesResponse.ReadOnly
      ]
  object AttachUserPolicy
      extends Effect[AttachUserPolicyRequest, AwsError, Unit]
  object DeleteServiceLinkedRole
      extends Effect[
        DeleteServiceLinkedRoleRequest,
        AwsError,
        zio.aws.iam.model.DeleteServiceLinkedRoleResponse.ReadOnly
      ]
  object ListUserTags
      extends Stream[
        ListUserTagsRequest,
        AwsError,
        zio.aws.iam.model.Tag.ReadOnly
      ]
  object ListUserTagsPaginated
      extends Effect[
        ListUserTagsRequest,
        AwsError,
        zio.aws.iam.model.ListUserTagsResponse.ReadOnly
      ]
  object UpdateRoleDescription
      extends Effect[
        UpdateRoleDescriptionRequest,
        AwsError,
        zio.aws.iam.model.UpdateRoleDescriptionResponse.ReadOnly
      ]
  object UpdateLoginProfile
      extends Effect[UpdateLoginProfileRequest, AwsError, Unit]
  object AttachRolePolicy
      extends Effect[AttachRolePolicyRequest, AwsError, Unit]
  object TagMFADevice extends Effect[TagMfaDeviceRequest, AwsError, Unit]
  object UpdateGroup extends Effect[UpdateGroupRequest, AwsError, Unit]
  object SimulatePrincipalPolicy
      extends Stream[
        SimulatePrincipalPolicyRequest,
        AwsError,
        zio.aws.iam.model.EvaluationResult.ReadOnly
      ]
  object SimulatePrincipalPolicyPaginated
      extends Effect[
        SimulatePrincipalPolicyRequest,
        AwsError,
        zio.aws.iam.model.SimulatePrincipalPolicyResponse.ReadOnly
      ]
  object UpdateAccountPasswordPolicy
      extends Effect[UpdateAccountPasswordPolicyRequest, AwsError, Unit]
  object ListAccountAliases
      extends Stream[ListAccountAliasesRequest, AwsError, AccountAliasType]
  object ListAccountAliasesPaginated
      extends Effect[
        ListAccountAliasesRequest,
        AwsError,
        zio.aws.iam.model.ListAccountAliasesResponse.ReadOnly
      ]
  object UpdateSSHPublicKey
      extends Effect[UpdateSshPublicKeyRequest, AwsError, Unit]
  object DeactivateMFADevice
      extends Effect[DeactivateMfaDeviceRequest, AwsError, Unit]
  object GetRole
      extends Effect[
        GetRoleRequest,
        AwsError,
        zio.aws.iam.model.GetRoleResponse.ReadOnly
      ]
  object ListOpenIDConnectProviderTags
      extends Effect[
        ListOpenIdConnectProviderTagsRequest,
        AwsError,
        zio.aws.iam.model.ListOpenIdConnectProviderTagsResponse.ReadOnly
      ]
  object GetInstanceProfile
      extends Effect[
        GetInstanceProfileRequest,
        AwsError,
        zio.aws.iam.model.GetInstanceProfileResponse.ReadOnly
      ]
  object CreatePolicy
      extends Effect[
        CreatePolicyRequest,
        AwsError,
        zio.aws.iam.model.CreatePolicyResponse.ReadOnly
      ]
  object GetAccountAuthorizationDetails
      extends Stream[
        GetAccountAuthorizationDetailsRequest,
        AwsError,
        zio.aws.iam.model.UserDetail.ReadOnly
      ]
  object GetAccountAuthorizationDetailsPaginated
      extends Effect[
        GetAccountAuthorizationDetailsRequest,
        AwsError,
        zio.aws.iam.model.GetAccountAuthorizationDetailsResponse.ReadOnly
      ]
  object ListPolicyTags
      extends Effect[
        ListPolicyTagsRequest,
        AwsError,
        zio.aws.iam.model.ListPolicyTagsResponse.ReadOnly
      ]
  object ListMFADevices
      extends Stream[
        ListMfaDevicesRequest,
        AwsError,
        zio.aws.iam.model.MFADevice.ReadOnly
      ]
  object ListMFADevicesPaginated
      extends Effect[
        ListMfaDevicesRequest,
        AwsError,
        zio.aws.iam.model.ListMfaDevicesResponse.ReadOnly
      ]
  object GenerateCredentialReport
      extends Effect[
        Unit,
        AwsError,
        zio.aws.iam.model.GenerateCredentialReportResponse.ReadOnly
      ]
  object ListOpenIDConnectProviders
      extends Effect[
        ListOpenIdConnectProvidersRequest,
        AwsError,
        zio.aws.iam.model.ListOpenIdConnectProvidersResponse.ReadOnly
      ]
  object TagSAMLProvider extends Effect[TagSamlProviderRequest, AwsError, Unit]
  object UpdateServiceSpecificCredential
      extends Effect[UpdateServiceSpecificCredentialRequest, AwsError, Unit]
  object DeletePolicy extends Effect[DeletePolicyRequest, AwsError, Unit]
  object DeleteUser extends Effect[DeleteUserRequest, AwsError, Unit]
  object ListRoleTags
      extends Effect[
        ListRoleTagsRequest,
        AwsError,
        zio.aws.iam.model.ListRoleTagsResponse.ReadOnly
      ]
  object GetGroup
      extends Stream[GetGroupRequest, AwsError, zio.aws.iam.model.User.ReadOnly]
  object GetGroupPaginated
      extends Effect[
        GetGroupRequest,
        AwsError,
        zio.aws.iam.model.GetGroupResponse.ReadOnly
      ]
  object GetPolicy
      extends Effect[
        GetPolicyRequest,
        AwsError,
        zio.aws.iam.model.GetPolicyResponse.ReadOnly
      ]
  object ListInstanceProfiles
      extends Stream[
        ListInstanceProfilesRequest,
        AwsError,
        zio.aws.iam.model.InstanceProfile.ReadOnly
      ]
  object ListInstanceProfilesPaginated
      extends Effect[
        ListInstanceProfilesRequest,
        AwsError,
        zio.aws.iam.model.ListInstanceProfilesResponse.ReadOnly
      ]
  object GetOrganizationsAccessReport
      extends Effect[
        GetOrganizationsAccessReportRequest,
        AwsError,
        zio.aws.iam.model.GetOrganizationsAccessReportResponse.ReadOnly
      ]
  object ListInstanceProfileTags
      extends Effect[
        ListInstanceProfileTagsRequest,
        AwsError,
        zio.aws.iam.model.ListInstanceProfileTagsResponse.ReadOnly
      ]
  object UpdateSigningCertificate
      extends Effect[UpdateSigningCertificateRequest, AwsError, Unit]
  object ListInstanceProfilesForRole
      extends Stream[
        ListInstanceProfilesForRoleRequest,
        AwsError,
        zio.aws.iam.model.InstanceProfile.ReadOnly
      ]
  object ListInstanceProfilesForRolePaginated
      extends Effect[
        ListInstanceProfilesForRoleRequest,
        AwsError,
        zio.aws.iam.model.ListInstanceProfilesForRoleResponse.ReadOnly
      ]
  object GetContextKeysForCustomPolicy
      extends Effect[
        GetContextKeysForCustomPolicyRequest,
        AwsError,
        zio.aws.iam.model.GetContextKeysForCustomPolicyResponse.ReadOnly
      ]
  object UpdateAssumeRolePolicy
      extends Effect[UpdateAssumeRolePolicyRequest, AwsError, Unit]
  object GetServerCertificate
      extends Effect[
        GetServerCertificateRequest,
        AwsError,
        zio.aws.iam.model.GetServerCertificateResponse.ReadOnly
      ]
  object CreateInstanceProfile
      extends Effect[
        CreateInstanceProfileRequest,
        AwsError,
        zio.aws.iam.model.CreateInstanceProfileResponse.ReadOnly
      ]
  object ListAccessKeys
      extends Stream[
        ListAccessKeysRequest,
        AwsError,
        zio.aws.iam.model.AccessKeyMetadata.ReadOnly
      ]
  object ListAccessKeysPaginated
      extends Effect[
        ListAccessKeysRequest,
        AwsError,
        zio.aws.iam.model.ListAccessKeysResponse.ReadOnly
      ]
  object GetServiceLastAccessedDetailsWithEntities
      extends Effect[
        GetServiceLastAccessedDetailsWithEntitiesRequest,
        AwsError,
        zio.aws.iam.model.GetServiceLastAccessedDetailsWithEntitiesResponse.ReadOnly
      ]
  object CreatePolicyVersion
      extends Effect[
        CreatePolicyVersionRequest,
        AwsError,
        zio.aws.iam.model.CreatePolicyVersionResponse.ReadOnly
      ]
  object DeleteRolePermissionsBoundary
      extends Effect[DeleteRolePermissionsBoundaryRequest, AwsError, Unit]
  object DeleteSAMLProvider
      extends Effect[DeleteSamlProviderRequest, AwsError, Unit]
  object ListServerCertificates
      extends Stream[
        ListServerCertificatesRequest,
        AwsError,
        zio.aws.iam.model.ServerCertificateMetadata.ReadOnly
      ]
  object ListServerCertificatesPaginated
      extends Effect[
        ListServerCertificatesRequest,
        AwsError,
        zio.aws.iam.model.ListServerCertificatesResponse.ReadOnly
      ]
  object GetServiceLinkedRoleDeletionStatus
      extends Effect[
        GetServiceLinkedRoleDeletionStatusRequest,
        AwsError,
        ReadOnly
      ]
  object TagPolicy extends Effect[TagPolicyRequest, AwsError, Unit]
  object GetPolicyVersion
      extends Effect[
        GetPolicyVersionRequest,
        AwsError,
        zio.aws.iam.model.GetPolicyVersionResponse.ReadOnly
      ]
  object TagUser extends Effect[TagUserRequest, AwsError, Unit]
  object GetAccessKeyLastUsed
      extends Effect[
        GetAccessKeyLastUsedRequest,
        AwsError,
        zio.aws.iam.model.GetAccessKeyLastUsedResponse.ReadOnly
      ]
  object UntagServerCertificate
      extends Effect[UntagServerCertificateRequest, AwsError, Unit]
  object GetSAMLProvider
      extends Effect[
        GetSamlProviderRequest,
        AwsError,
        zio.aws.iam.model.GetSamlProviderResponse.ReadOnly
      ]
  object ListServerCertificateTags
      extends Effect[
        ListServerCertificateTagsRequest,
        AwsError,
        zio.aws.iam.model.ListServerCertificateTagsResponse.ReadOnly
      ]
  object GetCredentialReport
      extends Effect[
        Unit,
        AwsError,
        zio.aws.iam.model.GetCredentialReportResponse.ReadOnly
      ]
  val compose: URLayer[Proxy, Iam] = zio.ZLayer {
    zio.ZIO.service[Proxy].flatMap { proxy =>
      withRuntime[Proxy, Iam] { rts =>
        zio.ZIO.succeed {
          new Iam {
            val api: IamAsyncClient = null
            def withAspect[R1](
                newAspect: AwsCallAspect[R1],
                r: ZEnvironment[R1]
            ): Iam = this
            def getOpenIDConnectProvider(
                request: GetOpenIdConnectProviderRequest
            ): IO[
              AwsError,
              zio.aws.iam.model.GetOpenIdConnectProviderResponse.ReadOnly
            ] = proxy(GetOpenIDConnectProvider, request)
            def listUserPolicies(
                request: ListUserPoliciesRequest
            ): ZStream[Any, AwsError, PolicyNameType] =
              rts.unsafeRun(proxy(ListUserPolicies, request))
            def listUserPoliciesPaginated(request: ListUserPoliciesRequest): IO[
              AwsError,
              zio.aws.iam.model.ListUserPoliciesResponse.ReadOnly
            ] = proxy(ListUserPoliciesPaginated, request)
            def deleteAccountAlias(
                request: DeleteAccountAliasRequest
            ): IO[AwsError, Unit] = proxy(DeleteAccountAlias, request)
            def deleteRolePolicy(
                request: DeleteRolePolicyRequest
            ): IO[AwsError, Unit] = proxy(DeleteRolePolicy, request)
            def uploadSSHPublicKey(request: UploadSshPublicKeyRequest): IO[
              AwsError,
              zio.aws.iam.model.UploadSshPublicKeyResponse.ReadOnly
            ] = proxy(UploadSSHPublicKey, request)
            def deleteOpenIDConnectProvider(
                request: DeleteOpenIdConnectProviderRequest
            ): IO[AwsError, Unit] = proxy(DeleteOpenIDConnectProvider, request)
            def listUsers(
                request: ListUsersRequest
            ): ZStream[Any, AwsError, zio.aws.iam.model.User.ReadOnly] =
              rts.unsafeRun(proxy(ListUsers, request))
            def listUsersPaginated(
                request: ListUsersRequest
            ): IO[AwsError, zio.aws.iam.model.ListUsersResponse.ReadOnly] =
              proxy(ListUsersPaginated, request)
            def tagServerCertificate(
                request: TagServerCertificateRequest
            ): IO[AwsError, Unit] = proxy(TagServerCertificate, request)
            def tagRole(request: TagRoleRequest): IO[AwsError, Unit] =
              proxy(TagRole, request)
            def updateUser(request: UpdateUserRequest): IO[AwsError, Unit] =
              proxy(UpdateUser, request)
            def updateSAMLProvider(request: UpdateSamlProviderRequest): IO[
              AwsError,
              zio.aws.iam.model.UpdateSamlProviderResponse.ReadOnly
            ] = proxy(UpdateSAMLProvider, request)
            def untagInstanceProfile(
                request: UntagInstanceProfileRequest
            ): IO[AwsError, Unit] = proxy(UntagInstanceProfile, request)
            def createSAMLProvider(request: CreateSamlProviderRequest): IO[
              AwsError,
              zio.aws.iam.model.CreateSamlProviderResponse.ReadOnly
            ] = proxy(CreateSAMLProvider, request)
            def enableMFADevice(
                request: EnableMfaDeviceRequest
            ): IO[AwsError, Unit] = proxy(EnableMFADevice, request)
            def removeClientIDFromOpenIDConnectProvider(
                request: RemoveClientIdFromOpenIdConnectProviderRequest
            ): IO[AwsError, Unit] =
              proxy(RemoveClientIDFromOpenIDConnectProvider, request)
            def addClientIDToOpenIDConnectProvider(
                request: AddClientIdToOpenIdConnectProviderRequest
            ): IO[AwsError, Unit] =
              proxy(AddClientIDToOpenIDConnectProvider, request)
            def listSSHPublicKeys(request: ListSshPublicKeysRequest): ZStream[
              Any,
              AwsError,
              zio.aws.iam.model.SSHPublicKeyMetadata.ReadOnly
            ] = rts.unsafeRun(proxy(ListSSHPublicKeys, request))
            def listSSHPublicKeysPaginated(
                request: ListSshPublicKeysRequest
            ): IO[
              AwsError,
              zio.aws.iam.model.ListSshPublicKeysResponse.ReadOnly
            ] = proxy(ListSSHPublicKeysPaginated, request)
            def getLoginProfile(request: GetLoginProfileRequest): IO[
              AwsError,
              zio.aws.iam.model.GetLoginProfileResponse.ReadOnly
            ] = proxy(GetLoginProfile, request)
            def uploadSigningCertificate(
                request: UploadSigningCertificateRequest
            ): IO[
              AwsError,
              zio.aws.iam.model.UploadSigningCertificateResponse.ReadOnly
            ] = proxy(UploadSigningCertificate, request)
            def detachRolePolicy(
                request: DetachRolePolicyRequest
            ): IO[AwsError, Unit] = proxy(DetachRolePolicy, request)
            def resyncMFADevice(
                request: ResyncMfaDeviceRequest
            ): IO[AwsError, Unit] = proxy(ResyncMFADevice, request)
            def listServiceSpecificCredentials(
                request: ListServiceSpecificCredentialsRequest
            ): IO[
              AwsError,
              zio.aws.iam.model.ListServiceSpecificCredentialsResponse.ReadOnly
            ] = proxy(ListServiceSpecificCredentials, request)
            def listAttachedRolePolicies(
                request: ListAttachedRolePoliciesRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.iam.model.AttachedPolicy.ReadOnly
            ] = rts.unsafeRun(proxy(ListAttachedRolePolicies, request))
            def listAttachedRolePoliciesPaginated(
                request: ListAttachedRolePoliciesRequest
            ): IO[
              AwsError,
              zio.aws.iam.model.ListAttachedRolePoliciesResponse.ReadOnly
            ] = proxy(ListAttachedRolePoliciesPaginated, request)
            def getSSHPublicKey(request: GetSshPublicKeyRequest): IO[
              AwsError,
              zio.aws.iam.model.GetSshPublicKeyResponse.ReadOnly
            ] = proxy(GetSSHPublicKey, request)
            def untagSAMLProvider(
                request: UntagSamlProviderRequest
            ): IO[AwsError, Unit] = proxy(UntagSAMLProvider, request)
            def simulateCustomPolicy(
                request: SimulateCustomPolicyRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.iam.model.EvaluationResult.ReadOnly
            ] = rts.unsafeRun(proxy(SimulateCustomPolicy, request))
            def simulateCustomPolicyPaginated(
                request: SimulateCustomPolicyRequest
            ): IO[
              AwsError,
              zio.aws.iam.model.SimulateCustomPolicyResponse.ReadOnly
            ] = proxy(SimulateCustomPolicyPaginated, request)
            def deleteAccessKey(
                request: DeleteAccessKeyRequest
            ): IO[AwsError, Unit] = proxy(DeleteAccessKey, request)
            def getServiceLastAccessedDetails(
                request: GetServiceLastAccessedDetailsRequest
            ): IO[
              AwsError,
              zio.aws.iam.model.GetServiceLastAccessedDetailsResponse.ReadOnly
            ] = proxy(GetServiceLastAccessedDetails, request)
            def deleteUserPolicy(
                request: DeleteUserPolicyRequest
            ): IO[AwsError, Unit] = proxy(DeleteUserPolicy, request)
            def untagUser(request: UntagUserRequest): IO[AwsError, Unit] =
              proxy(UntagUser, request)
            def createServiceSpecificCredential(
                request: CreateServiceSpecificCredentialRequest
            ): IO[
              AwsError,
              zio.aws.iam.model.CreateServiceSpecificCredentialResponse.ReadOnly
            ] = proxy(CreateServiceSpecificCredential, request)
            def listSAMLProviders(request: ListSamlProvidersRequest): IO[
              AwsError,
              zio.aws.iam.model.ListSamlProvidersResponse.ReadOnly
            ] = proxy(ListSAMLProviders, request)
            def listPoliciesGrantingServiceAccess(
                request: ListPoliciesGrantingServiceAccessRequest
            ): IO[
              AwsError,
              zio.aws.iam.model.ListPoliciesGrantingServiceAccessResponse.ReadOnly
            ] = proxy(ListPoliciesGrantingServiceAccess, request)
            def getGroupPolicy(
                request: GetGroupPolicyRequest
            ): IO[AwsError, zio.aws.iam.model.GetGroupPolicyResponse.ReadOnly] =
              proxy(GetGroupPolicy, request)
            def uploadServerCertificate(
                request: UploadServerCertificateRequest
            ): IO[
              AwsError,
              zio.aws.iam.model.UploadServerCertificateResponse.ReadOnly
            ] = proxy(UploadServerCertificate, request)
            def updateServerCertificate(
                request: UpdateServerCertificateRequest
            ): IO[AwsError, Unit] = proxy(UpdateServerCertificate, request)
            def deleteGroup(request: DeleteGroupRequest): IO[AwsError, Unit] =
              proxy(DeleteGroup, request)
            def removeRoleFromInstanceProfile(
                request: RemoveRoleFromInstanceProfileRequest
            ): IO[AwsError, Unit] =
              proxy(RemoveRoleFromInstanceProfile, request)
            def createRole(
                request: CreateRoleRequest
            ): IO[AwsError, zio.aws.iam.model.CreateRoleResponse.ReadOnly] =
              proxy(CreateRole, request)
            def getAccountSummary(): IO[
              AwsError,
              zio.aws.iam.model.GetAccountSummaryResponse.ReadOnly
            ] = proxy(GetAccountSummary)
            def changePassword(
                request: ChangePasswordRequest
            ): IO[AwsError, Unit] = proxy(ChangePassword, request)
            def listRolePolicies(
                request: ListRolePoliciesRequest
            ): ZStream[Any, AwsError, PolicyNameType] =
              rts.unsafeRun(proxy(ListRolePolicies, request))
            def listRolePoliciesPaginated(request: ListRolePoliciesRequest): IO[
              AwsError,
              zio.aws.iam.model.ListRolePoliciesResponse.ReadOnly
            ] = proxy(ListRolePoliciesPaginated, request)
            def detachGroupPolicy(
                request: DetachGroupPolicyRequest
            ): IO[AwsError, Unit] = proxy(DetachGroupPolicy, request)
            def listGroupsForUser(
                request: ListGroupsForUserRequest
            ): ZStream[Any, AwsError, zio.aws.iam.model.Group.ReadOnly] =
              rts.unsafeRun(proxy(ListGroupsForUser, request))
            def listGroupsForUserPaginated(
                request: ListGroupsForUserRequest
            ): IO[
              AwsError,
              zio.aws.iam.model.ListGroupsForUserResponse.ReadOnly
            ] = proxy(ListGroupsForUserPaginated, request)
            def deleteVirtualMFADevice(
                request: DeleteVirtualMfaDeviceRequest
            ): IO[AwsError, Unit] = proxy(DeleteVirtualMFADevice, request)
            def listAttachedGroupPolicies(
                request: ListAttachedGroupPoliciesRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.iam.model.AttachedPolicy.ReadOnly
            ] = rts.unsafeRun(proxy(ListAttachedGroupPolicies, request))
            def listAttachedGroupPoliciesPaginated(
                request: ListAttachedGroupPoliciesRequest
            ): IO[
              AwsError,
              zio.aws.iam.model.ListAttachedGroupPoliciesResponse.ReadOnly
            ] = proxy(ListAttachedGroupPoliciesPaginated, request)
            def getUser(
                request: GetUserRequest
            ): IO[AwsError, zio.aws.iam.model.GetUserResponse.ReadOnly] =
              proxy(GetUser, request)
            def deleteAccountPasswordPolicy(): IO[AwsError, Unit] =
              proxy(DeleteAccountPasswordPolicy)
            def getContextKeysForPrincipalPolicy(
                request: GetContextKeysForPrincipalPolicyRequest
            ): IO[
              AwsError,
              zio.aws.iam.model.GetContextKeysForPrincipalPolicyResponse.ReadOnly
            ] = proxy(GetContextKeysForPrincipalPolicy, request)
            def listGroups(
                request: ListGroupsRequest
            ): ZStream[Any, AwsError, zio.aws.iam.model.Group.ReadOnly] =
              rts.unsafeRun(proxy(ListGroups, request))
            def listGroupsPaginated(
                request: ListGroupsRequest
            ): IO[AwsError, zio.aws.iam.model.ListGroupsResponse.ReadOnly] =
              proxy(ListGroupsPaginated, request)
            def listPolicyVersions(request: ListPolicyVersionsRequest): ZStream[
              Any,
              AwsError,
              zio.aws.iam.model.PolicyVersion.ReadOnly
            ] = rts.unsafeRun(proxy(ListPolicyVersions, request))
            def listPolicyVersionsPaginated(
                request: ListPolicyVersionsRequest
            ): IO[
              AwsError,
              zio.aws.iam.model.ListPolicyVersionsResponse.ReadOnly
            ] = proxy(ListPolicyVersionsPaginated, request)
            def getRolePolicy(
                request: GetRolePolicyRequest
            ): IO[AwsError, zio.aws.iam.model.GetRolePolicyResponse.ReadOnly] =
              proxy(GetRolePolicy, request)
            def tagOpenIDConnectProvider(
                request: TagOpenIdConnectProviderRequest
            ): IO[AwsError, Unit] = proxy(TagOpenIDConnectProvider, request)
            def deleteRole(request: DeleteRoleRequest): IO[AwsError, Unit] =
              proxy(DeleteRole, request)
            def updateOpenIDConnectProviderThumbprint(
                request: UpdateOpenIdConnectProviderThumbprintRequest
            ): IO[AwsError, Unit] =
              proxy(UpdateOpenIDConnectProviderThumbprint, request)
            def untagPolicy(request: UntagPolicyRequest): IO[AwsError, Unit] =
              proxy(UntagPolicy, request)
            def detachUserPolicy(
                request: DetachUserPolicyRequest
            ): IO[AwsError, Unit] = proxy(DetachUserPolicy, request)
            def listEntitiesForPolicy(
                request: ListEntitiesForPolicyRequest
            ): ZStream[Any, AwsError, zio.aws.iam.model.PolicyGroup.ReadOnly] =
              rts.unsafeRun(proxy(ListEntitiesForPolicy, request))
            def listEntitiesForPolicyPaginated(
                request: ListEntitiesForPolicyRequest
            ): IO[
              AwsError,
              zio.aws.iam.model.ListEntitiesForPolicyResponse.ReadOnly
            ] = proxy(ListEntitiesForPolicyPaginated, request)
            def listMFADeviceTags(request: ListMfaDeviceTagsRequest): IO[
              AwsError,
              zio.aws.iam.model.ListMfaDeviceTagsResponse.ReadOnly
            ] = proxy(ListMFADeviceTags, request)
            def deleteSSHPublicKey(
                request: DeleteSshPublicKeyRequest
            ): IO[AwsError, Unit] = proxy(DeleteSSHPublicKey, request)
            def createUser(
                request: CreateUserRequest
            ): IO[AwsError, zio.aws.iam.model.CreateUserResponse.ReadOnly] =
              proxy(CreateUser, request)
            def deleteSigningCertificate(
                request: DeleteSigningCertificateRequest
            ): IO[AwsError, Unit] = proxy(DeleteSigningCertificate, request)
            def setDefaultPolicyVersion(
                request: SetDefaultPolicyVersionRequest
            ): IO[AwsError, Unit] = proxy(SetDefaultPolicyVersion, request)
            def updateRole(
                request: UpdateRoleRequest
            ): IO[AwsError, zio.aws.iam.model.UpdateRoleResponse.ReadOnly] =
              proxy(UpdateRole, request)
            def listSAMLProviderTags(request: ListSamlProviderTagsRequest): IO[
              AwsError,
              zio.aws.iam.model.ListSamlProviderTagsResponse.ReadOnly
            ] = proxy(ListSAMLProviderTags, request)
            def createServiceLinkedRole(
                request: CreateServiceLinkedRoleRequest
            ): IO[
              AwsError,
              zio.aws.iam.model.CreateServiceLinkedRoleResponse.ReadOnly
            ] = proxy(CreateServiceLinkedRole, request)
            def addUserToGroup(
                request: AddUserToGroupRequest
            ): IO[AwsError, Unit] = proxy(AddUserToGroup, request)
            def deleteServiceSpecificCredential(
                request: DeleteServiceSpecificCredentialRequest
            ): IO[AwsError, Unit] =
              proxy(DeleteServiceSpecificCredential, request)
            def putRolePermissionsBoundary(
                request: PutRolePermissionsBoundaryRequest
            ): IO[AwsError, Unit] = proxy(PutRolePermissionsBoundary, request)
            def deleteUserPermissionsBoundary(
                request: DeleteUserPermissionsBoundaryRequest
            ): IO[AwsError, Unit] =
              proxy(DeleteUserPermissionsBoundary, request)
            def putRolePolicy(
                request: PutRolePolicyRequest
            ): IO[AwsError, Unit] = proxy(PutRolePolicy, request)
            def listSigningCertificates(
                request: ListSigningCertificatesRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.iam.model.SigningCertificate.ReadOnly
            ] = rts.unsafeRun(proxy(ListSigningCertificates, request))
            def listSigningCertificatesPaginated(
                request: ListSigningCertificatesRequest
            ): IO[
              AwsError,
              zio.aws.iam.model.ListSigningCertificatesResponse.ReadOnly
            ] = proxy(ListSigningCertificatesPaginated, request)
            def createAccessKey(request: CreateAccessKeyRequest): IO[
              AwsError,
              zio.aws.iam.model.CreateAccessKeyResponse.ReadOnly
            ] = proxy(CreateAccessKey, request)
            def untagOpenIDConnectProvider(
                request: UntagOpenIdConnectProviderRequest
            ): IO[AwsError, Unit] = proxy(UntagOpenIDConnectProvider, request)
            def tagInstanceProfile(
                request: TagInstanceProfileRequest
            ): IO[AwsError, Unit] = proxy(TagInstanceProfile, request)
            def listRoles(
                request: ListRolesRequest
            ): ZStream[Any, AwsError, zio.aws.iam.model.Role.ReadOnly] =
              rts.unsafeRun(proxy(ListRoles, request))
            def listRolesPaginated(
                request: ListRolesRequest
            ): IO[AwsError, zio.aws.iam.model.ListRolesResponse.ReadOnly] =
              proxy(ListRolesPaginated, request)
            def listPolicies(
                request: ListPoliciesRequest
            ): ZStream[Any, AwsError, zio.aws.iam.model.Policy.ReadOnly] =
              rts.unsafeRun(proxy(ListPolicies, request))
            def listPoliciesPaginated(
                request: ListPoliciesRequest
            ): IO[AwsError, zio.aws.iam.model.ListPoliciesResponse.ReadOnly] =
              proxy(ListPoliciesPaginated, request)
            def putGroupPolicy(
                request: PutGroupPolicyRequest
            ): IO[AwsError, Unit] = proxy(PutGroupPolicy, request)
            def createLoginProfile(request: CreateLoginProfileRequest): IO[
              AwsError,
              zio.aws.iam.model.CreateLoginProfileResponse.ReadOnly
            ] = proxy(CreateLoginProfile, request)
            def deleteGroupPolicy(
                request: DeleteGroupPolicyRequest
            ): IO[AwsError, Unit] = proxy(DeleteGroupPolicy, request)
            def createOpenIDConnectProvider(
                request: CreateOpenIdConnectProviderRequest
            ): IO[
              AwsError,
              zio.aws.iam.model.CreateOpenIdConnectProviderResponse.ReadOnly
            ] = proxy(CreateOpenIDConnectProvider, request)
            def generateOrganizationsAccessReport(
                request: GenerateOrganizationsAccessReportRequest
            ): IO[
              AwsError,
              zio.aws.iam.model.GenerateOrganizationsAccessReportResponse.ReadOnly
            ] = proxy(GenerateOrganizationsAccessReport, request)
            def generateServiceLastAccessedDetails(
                request: GenerateServiceLastAccessedDetailsRequest
            ): IO[
              AwsError,
              zio.aws.iam.model.GenerateServiceLastAccessedDetailsResponse.ReadOnly
            ] = proxy(GenerateServiceLastAccessedDetails, request)
            def getUserPolicy(
                request: GetUserPolicyRequest
            ): IO[AwsError, zio.aws.iam.model.GetUserPolicyResponse.ReadOnly] =
              proxy(GetUserPolicy, request)
            def getAccountPasswordPolicy(): IO[
              AwsError,
              zio.aws.iam.model.GetAccountPasswordPolicyResponse.ReadOnly
            ] = proxy(GetAccountPasswordPolicy)
            def updateAccessKey(
                request: UpdateAccessKeyRequest
            ): IO[AwsError, Unit] = proxy(UpdateAccessKey, request)
            def deletePolicyVersion(
                request: DeletePolicyVersionRequest
            ): IO[AwsError, Unit] = proxy(DeletePolicyVersion, request)
            def createVirtualMFADevice(
                request: CreateVirtualMfaDeviceRequest
            ): IO[
              AwsError,
              zio.aws.iam.model.CreateVirtualMfaDeviceResponse.ReadOnly
            ] = proxy(CreateVirtualMFADevice, request)
            def removeUserFromGroup(
                request: RemoveUserFromGroupRequest
            ): IO[AwsError, Unit] = proxy(RemoveUserFromGroup, request)
            def deleteServerCertificate(
                request: DeleteServerCertificateRequest
            ): IO[AwsError, Unit] = proxy(DeleteServerCertificate, request)
            def untagRole(request: UntagRoleRequest): IO[AwsError, Unit] =
              proxy(UntagRole, request)
            def addRoleToInstanceProfile(
                request: AddRoleToInstanceProfileRequest
            ): IO[AwsError, Unit] = proxy(AddRoleToInstanceProfile, request)
            def putUserPermissionsBoundary(
                request: PutUserPermissionsBoundaryRequest
            ): IO[AwsError, Unit] = proxy(PutUserPermissionsBoundary, request)
            def resetServiceSpecificCredential(
                request: ResetServiceSpecificCredentialRequest
            ): IO[
              AwsError,
              zio.aws.iam.model.ResetServiceSpecificCredentialResponse.ReadOnly
            ] = proxy(ResetServiceSpecificCredential, request)
            def listVirtualMFADevices(
                request: ListVirtualMfaDevicesRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.iam.model.VirtualMFADevice.ReadOnly
            ] = rts.unsafeRun(proxy(ListVirtualMFADevices, request))
            def listVirtualMFADevicesPaginated(
                request: ListVirtualMfaDevicesRequest
            ): IO[
              AwsError,
              zio.aws.iam.model.ListVirtualMfaDevicesResponse.ReadOnly
            ] = proxy(ListVirtualMFADevicesPaginated, request)
            def deleteLoginProfile(
                request: DeleteLoginProfileRequest
            ): IO[AwsError, Unit] = proxy(DeleteLoginProfile, request)
            def listGroupPolicies(
                request: ListGroupPoliciesRequest
            ): ZStream[Any, AwsError, PolicyNameType] =
              rts.unsafeRun(proxy(ListGroupPolicies, request))
            def listGroupPoliciesPaginated(
                request: ListGroupPoliciesRequest
            ): IO[
              AwsError,
              zio.aws.iam.model.ListGroupPoliciesResponse.ReadOnly
            ] = proxy(ListGroupPoliciesPaginated, request)
            def deleteInstanceProfile(
                request: DeleteInstanceProfileRequest
            ): IO[AwsError, Unit] = proxy(DeleteInstanceProfile, request)
            def createGroup(
                request: CreateGroupRequest
            ): IO[AwsError, zio.aws.iam.model.CreateGroupResponse.ReadOnly] =
              proxy(CreateGroup, request)
            def untagMFADevice(
                request: UntagMfaDeviceRequest
            ): IO[AwsError, Unit] = proxy(UntagMFADevice, request)
            def createAccountAlias(
                request: CreateAccountAliasRequest
            ): IO[AwsError, Unit] = proxy(CreateAccountAlias, request)
            def attachGroupPolicy(
                request: AttachGroupPolicyRequest
            ): IO[AwsError, Unit] = proxy(AttachGroupPolicy, request)
            def setSecurityTokenServicePreferences(
                request: SetSecurityTokenServicePreferencesRequest
            ): IO[AwsError, Unit] =
              proxy(SetSecurityTokenServicePreferences, request)
            def putUserPolicy(
                request: PutUserPolicyRequest
            ): IO[AwsError, Unit] = proxy(PutUserPolicy, request)
            def listAttachedUserPolicies(
                request: ListAttachedUserPoliciesRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.iam.model.AttachedPolicy.ReadOnly
            ] = rts.unsafeRun(proxy(ListAttachedUserPolicies, request))
            def listAttachedUserPoliciesPaginated(
                request: ListAttachedUserPoliciesRequest
            ): IO[
              AwsError,
              zio.aws.iam.model.ListAttachedUserPoliciesResponse.ReadOnly
            ] = proxy(ListAttachedUserPoliciesPaginated, request)
            def attachUserPolicy(
                request: AttachUserPolicyRequest
            ): IO[AwsError, Unit] = proxy(AttachUserPolicy, request)
            def deleteServiceLinkedRole(
                request: DeleteServiceLinkedRoleRequest
            ): IO[
              AwsError,
              zio.aws.iam.model.DeleteServiceLinkedRoleResponse.ReadOnly
            ] = proxy(DeleteServiceLinkedRole, request)
            def listUserTags(
                request: ListUserTagsRequest
            ): ZStream[Any, AwsError, zio.aws.iam.model.Tag.ReadOnly] =
              rts.unsafeRun(proxy(ListUserTags, request))
            def listUserTagsPaginated(
                request: ListUserTagsRequest
            ): IO[AwsError, zio.aws.iam.model.ListUserTagsResponse.ReadOnly] =
              proxy(ListUserTagsPaginated, request)
            def updateRoleDescription(
                request: UpdateRoleDescriptionRequest
            ): IO[
              AwsError,
              zio.aws.iam.model.UpdateRoleDescriptionResponse.ReadOnly
            ] = proxy(UpdateRoleDescription, request)
            def updateLoginProfile(
                request: UpdateLoginProfileRequest
            ): IO[AwsError, Unit] = proxy(UpdateLoginProfile, request)
            def attachRolePolicy(
                request: AttachRolePolicyRequest
            ): IO[AwsError, Unit] = proxy(AttachRolePolicy, request)
            def tagMFADevice(request: TagMfaDeviceRequest): IO[AwsError, Unit] =
              proxy(TagMFADevice, request)
            def updateGroup(request: UpdateGroupRequest): IO[AwsError, Unit] =
              proxy(UpdateGroup, request)
            def simulatePrincipalPolicy(
                request: SimulatePrincipalPolicyRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.iam.model.EvaluationResult.ReadOnly
            ] = rts.unsafeRun(proxy(SimulatePrincipalPolicy, request))
            def simulatePrincipalPolicyPaginated(
                request: SimulatePrincipalPolicyRequest
            ): IO[
              AwsError,
              zio.aws.iam.model.SimulatePrincipalPolicyResponse.ReadOnly
            ] = proxy(SimulatePrincipalPolicyPaginated, request)
            def updateAccountPasswordPolicy(
                request: UpdateAccountPasswordPolicyRequest
            ): IO[AwsError, Unit] = proxy(UpdateAccountPasswordPolicy, request)
            def listAccountAliases(
                request: ListAccountAliasesRequest
            ): ZStream[Any, AwsError, AccountAliasType] =
              rts.unsafeRun(proxy(ListAccountAliases, request))
            def listAccountAliasesPaginated(
                request: ListAccountAliasesRequest
            ): IO[
              AwsError,
              zio.aws.iam.model.ListAccountAliasesResponse.ReadOnly
            ] = proxy(ListAccountAliasesPaginated, request)
            def updateSSHPublicKey(
                request: UpdateSshPublicKeyRequest
            ): IO[AwsError, Unit] = proxy(UpdateSSHPublicKey, request)
            def deactivateMFADevice(
                request: DeactivateMfaDeviceRequest
            ): IO[AwsError, Unit] = proxy(DeactivateMFADevice, request)
            def getRole(
                request: GetRoleRequest
            ): IO[AwsError, zio.aws.iam.model.GetRoleResponse.ReadOnly] =
              proxy(GetRole, request)
            def listOpenIDConnectProviderTags(
                request: ListOpenIdConnectProviderTagsRequest
            ): IO[
              AwsError,
              zio.aws.iam.model.ListOpenIdConnectProviderTagsResponse.ReadOnly
            ] = proxy(ListOpenIDConnectProviderTags, request)
            def getInstanceProfile(request: GetInstanceProfileRequest): IO[
              AwsError,
              zio.aws.iam.model.GetInstanceProfileResponse.ReadOnly
            ] = proxy(GetInstanceProfile, request)
            def createPolicy(
                request: CreatePolicyRequest
            ): IO[AwsError, zio.aws.iam.model.CreatePolicyResponse.ReadOnly] =
              proxy(CreatePolicy, request)
            def getAccountAuthorizationDetails(
                request: GetAccountAuthorizationDetailsRequest
            ): ZStream[Any, AwsError, zio.aws.iam.model.UserDetail.ReadOnly] =
              rts.unsafeRun(proxy(GetAccountAuthorizationDetails, request))
            def getAccountAuthorizationDetailsPaginated(
                request: GetAccountAuthorizationDetailsRequest
            ): IO[
              AwsError,
              zio.aws.iam.model.GetAccountAuthorizationDetailsResponse.ReadOnly
            ] = proxy(GetAccountAuthorizationDetailsPaginated, request)
            def listPolicyTags(
                request: ListPolicyTagsRequest
            ): IO[AwsError, zio.aws.iam.model.ListPolicyTagsResponse.ReadOnly] =
              proxy(ListPolicyTags, request)
            def listMFADevices(
                request: ListMfaDevicesRequest
            ): ZStream[Any, AwsError, zio.aws.iam.model.MFADevice.ReadOnly] =
              rts.unsafeRun(proxy(ListMFADevices, request))
            def listMFADevicesPaginated(
                request: ListMfaDevicesRequest
            ): IO[AwsError, zio.aws.iam.model.ListMfaDevicesResponse.ReadOnly] =
              proxy(ListMFADevicesPaginated, request)
            def generateCredentialReport(): IO[
              AwsError,
              zio.aws.iam.model.GenerateCredentialReportResponse.ReadOnly
            ] = proxy(GenerateCredentialReport)
            def listOpenIDConnectProviders(
                request: ListOpenIdConnectProvidersRequest
            ): IO[
              AwsError,
              zio.aws.iam.model.ListOpenIdConnectProvidersResponse.ReadOnly
            ] = proxy(ListOpenIDConnectProviders, request)
            def tagSAMLProvider(
                request: TagSamlProviderRequest
            ): IO[AwsError, Unit] = proxy(TagSAMLProvider, request)
            def updateServiceSpecificCredential(
                request: UpdateServiceSpecificCredentialRequest
            ): IO[AwsError, Unit] =
              proxy(UpdateServiceSpecificCredential, request)
            def deletePolicy(request: DeletePolicyRequest): IO[AwsError, Unit] =
              proxy(DeletePolicy, request)
            def deleteUser(request: DeleteUserRequest): IO[AwsError, Unit] =
              proxy(DeleteUser, request)
            def listRoleTags(
                request: ListRoleTagsRequest
            ): IO[AwsError, zio.aws.iam.model.ListRoleTagsResponse.ReadOnly] =
              proxy(ListRoleTags, request)
            def getGroup(
                request: GetGroupRequest
            ): ZStream[Any, AwsError, zio.aws.iam.model.User.ReadOnly] =
              rts.unsafeRun(proxy(GetGroup, request))
            def getGroupPaginated(
                request: GetGroupRequest
            ): IO[AwsError, zio.aws.iam.model.GetGroupResponse.ReadOnly] =
              proxy(GetGroupPaginated, request)
            def getPolicy(
                request: GetPolicyRequest
            ): IO[AwsError, zio.aws.iam.model.GetPolicyResponse.ReadOnly] =
              proxy(GetPolicy, request)
            def listInstanceProfiles(
                request: ListInstanceProfilesRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.iam.model.InstanceProfile.ReadOnly
            ] = rts.unsafeRun(proxy(ListInstanceProfiles, request))
            def listInstanceProfilesPaginated(
                request: ListInstanceProfilesRequest
            ): IO[
              AwsError,
              zio.aws.iam.model.ListInstanceProfilesResponse.ReadOnly
            ] = proxy(ListInstanceProfilesPaginated, request)
            def getOrganizationsAccessReport(
                request: GetOrganizationsAccessReportRequest
            ): IO[
              AwsError,
              zio.aws.iam.model.GetOrganizationsAccessReportResponse.ReadOnly
            ] = proxy(GetOrganizationsAccessReport, request)
            def listInstanceProfileTags(
                request: ListInstanceProfileTagsRequest
            ): IO[
              AwsError,
              zio.aws.iam.model.ListInstanceProfileTagsResponse.ReadOnly
            ] = proxy(ListInstanceProfileTags, request)
            def updateSigningCertificate(
                request: UpdateSigningCertificateRequest
            ): IO[AwsError, Unit] = proxy(UpdateSigningCertificate, request)
            def listInstanceProfilesForRole(
                request: ListInstanceProfilesForRoleRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.iam.model.InstanceProfile.ReadOnly
            ] = rts.unsafeRun(proxy(ListInstanceProfilesForRole, request))
            def listInstanceProfilesForRolePaginated(
                request: ListInstanceProfilesForRoleRequest
            ): IO[
              AwsError,
              zio.aws.iam.model.ListInstanceProfilesForRoleResponse.ReadOnly
            ] = proxy(ListInstanceProfilesForRolePaginated, request)
            def getContextKeysForCustomPolicy(
                request: GetContextKeysForCustomPolicyRequest
            ): IO[
              AwsError,
              zio.aws.iam.model.GetContextKeysForCustomPolicyResponse.ReadOnly
            ] = proxy(GetContextKeysForCustomPolicy, request)
            def updateAssumeRolePolicy(
                request: UpdateAssumeRolePolicyRequest
            ): IO[AwsError, Unit] = proxy(UpdateAssumeRolePolicy, request)
            def getServerCertificate(request: GetServerCertificateRequest): IO[
              AwsError,
              zio.aws.iam.model.GetServerCertificateResponse.ReadOnly
            ] = proxy(GetServerCertificate, request)
            def createInstanceProfile(
                request: CreateInstanceProfileRequest
            ): IO[
              AwsError,
              zio.aws.iam.model.CreateInstanceProfileResponse.ReadOnly
            ] = proxy(CreateInstanceProfile, request)
            def listAccessKeys(request: ListAccessKeysRequest): ZStream[
              Any,
              AwsError,
              zio.aws.iam.model.AccessKeyMetadata.ReadOnly
            ] = rts.unsafeRun(proxy(ListAccessKeys, request))
            def listAccessKeysPaginated(
                request: ListAccessKeysRequest
            ): IO[AwsError, zio.aws.iam.model.ListAccessKeysResponse.ReadOnly] =
              proxy(ListAccessKeysPaginated, request)
            def getServiceLastAccessedDetailsWithEntities(
                request: GetServiceLastAccessedDetailsWithEntitiesRequest
            ): IO[
              AwsError,
              zio.aws.iam.model.GetServiceLastAccessedDetailsWithEntitiesResponse.ReadOnly
            ] = proxy(GetServiceLastAccessedDetailsWithEntities, request)
            def createPolicyVersion(request: CreatePolicyVersionRequest): IO[
              AwsError,
              zio.aws.iam.model.CreatePolicyVersionResponse.ReadOnly
            ] = proxy(CreatePolicyVersion, request)
            def deleteRolePermissionsBoundary(
                request: DeleteRolePermissionsBoundaryRequest
            ): IO[AwsError, Unit] =
              proxy(DeleteRolePermissionsBoundary, request)
            def deleteSAMLProvider(
                request: DeleteSamlProviderRequest
            ): IO[AwsError, Unit] = proxy(DeleteSAMLProvider, request)
            def listServerCertificates(
                request: ListServerCertificatesRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.iam.model.ServerCertificateMetadata.ReadOnly
            ] = rts.unsafeRun(proxy(ListServerCertificates, request))
            def listServerCertificatesPaginated(
                request: ListServerCertificatesRequest
            ): IO[
              AwsError,
              zio.aws.iam.model.ListServerCertificatesResponse.ReadOnly
            ] = proxy(ListServerCertificatesPaginated, request)
            def getServiceLinkedRoleDeletionStatus(
                request: GetServiceLinkedRoleDeletionStatusRequest
            ): IO[AwsError, ReadOnly] =
              proxy(GetServiceLinkedRoleDeletionStatus, request)
            def tagPolicy(request: TagPolicyRequest): IO[AwsError, Unit] =
              proxy(TagPolicy, request)
            def getPolicyVersion(request: GetPolicyVersionRequest): IO[
              AwsError,
              zio.aws.iam.model.GetPolicyVersionResponse.ReadOnly
            ] = proxy(GetPolicyVersion, request)
            def tagUser(request: TagUserRequest): IO[AwsError, Unit] =
              proxy(TagUser, request)
            def getAccessKeyLastUsed(request: GetAccessKeyLastUsedRequest): IO[
              AwsError,
              zio.aws.iam.model.GetAccessKeyLastUsedResponse.ReadOnly
            ] = proxy(GetAccessKeyLastUsed, request)
            def untagServerCertificate(
                request: UntagServerCertificateRequest
            ): IO[AwsError, Unit] = proxy(UntagServerCertificate, request)
            def getSAMLProvider(request: GetSamlProviderRequest): IO[
              AwsError,
              zio.aws.iam.model.GetSamlProviderResponse.ReadOnly
            ] = proxy(GetSAMLProvider, request)
            def listServerCertificateTags(
                request: ListServerCertificateTagsRequest
            ): IO[
              AwsError,
              zio.aws.iam.model.ListServerCertificateTagsResponse.ReadOnly
            ] = proxy(ListServerCertificateTags, request)
            def getCredentialReport(): IO[
              AwsError,
              zio.aws.iam.model.GetCredentialReportResponse.ReadOnly
            ] = proxy(GetCredentialReport)
          }
        }
      }
    }
  }
}
