package zio.aws.iam.model
import scala.jdk.CollectionConverters.*
sealed trait AccessAdvisorUsageGranularityType {
  def unwrap: software.amazon.awssdk.services.iam.model.AccessAdvisorUsageGranularityType
}
object AccessAdvisorUsageGranularityType {
  def wrap(
      value: software.amazon.awssdk.services.iam.model.AccessAdvisorUsageGranularityType
  ): zio.aws.iam.model.AccessAdvisorUsageGranularityType = value match {
    case software.amazon.awssdk.services.iam.model.AccessAdvisorUsageGranularityType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.iam.model.AccessAdvisorUsageGranularityType.SERVICE_LEVEL =>
      val r = SERVICE_LEVEL
      r
    case software.amazon.awssdk.services.iam.model.AccessAdvisorUsageGranularityType.ACTION_LEVEL =>
      val r = ACTION_LEVEL
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.iam.model.AccessAdvisorUsageGranularityType {
    override def unwrap
        : software.amazon.awssdk.services.iam.model.AccessAdvisorUsageGranularityType =
      software.amazon.awssdk.services.iam.model.AccessAdvisorUsageGranularityType.UNKNOWN_TO_SDK_VERSION
  }
  case object SERVICE_LEVEL
      extends zio.aws.iam.model.AccessAdvisorUsageGranularityType {
    override def unwrap
        : software.amazon.awssdk.services.iam.model.AccessAdvisorUsageGranularityType =
      software.amazon.awssdk.services.iam.model.AccessAdvisorUsageGranularityType.SERVICE_LEVEL
  }
  case object ACTION_LEVEL
      extends zio.aws.iam.model.AccessAdvisorUsageGranularityType {
    override def unwrap
        : software.amazon.awssdk.services.iam.model.AccessAdvisorUsageGranularityType =
      software.amazon.awssdk.services.iam.model.AccessAdvisorUsageGranularityType.ACTION_LEVEL
  }
}
