package zio.aws.iam.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.iam.model.primitives.{DateType, AccessKeyIdType, UserNameType}
import scala.jdk.CollectionConverters.*
final case class AccessKeyMetadata(
    userName: Optional[UserNameType] = Optional.Absent,
    accessKeyId: Optional[AccessKeyIdType] = Optional.Absent,
    status: Optional[zio.aws.iam.model.StatusType] = Optional.Absent,
    createDate: Optional[DateType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iam.model.AccessKeyMetadata = {
    import AccessKeyMetadata.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iam.model.AccessKeyMetadata
      .builder()
      .optionallyWith(
        userName.map(value => UserNameType.unwrap(value): java.lang.String)
      )(_.userName)
      .optionallyWith(
        accessKeyId.map(value =>
          AccessKeyIdType.unwrap(value): java.lang.String
        )
      )(_.accessKeyId)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(createDate.map(value => DateType.unwrap(value): Instant))(
        _.createDate
      )
      .build()
  }
  def asReadOnly: zio.aws.iam.model.AccessKeyMetadata.ReadOnly =
    zio.aws.iam.model.AccessKeyMetadata.wrap(buildAwsValue())
}
object AccessKeyMetadata {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iam.model.AccessKeyMetadata
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iam.model.AccessKeyMetadata =
      zio.aws.iam.model.AccessKeyMetadata(
        userName.map(value => value),
        accessKeyId.map(value => value),
        status.map(value => value),
        createDate.map(value => value)
      )
    def userName: Optional[UserNameType]
    def accessKeyId: Optional[AccessKeyIdType]
    def status: Optional[zio.aws.iam.model.StatusType]
    def createDate: Optional[DateType]
    def getUserName: ZIO[Any, AwsError, UserNameType] =
      AwsError.unwrapOptionField("userName", userName)
    def getAccessKeyId: ZIO[Any, AwsError, AccessKeyIdType] =
      AwsError.unwrapOptionField("accessKeyId", accessKeyId)
    def getStatus: ZIO[Any, AwsError, zio.aws.iam.model.StatusType] =
      AwsError.unwrapOptionField("status", status)
    def getCreateDate: ZIO[Any, AwsError, DateType] =
      AwsError.unwrapOptionField("createDate", createDate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iam.model.AccessKeyMetadata
  ) extends zio.aws.iam.model.AccessKeyMetadata.ReadOnly {
    override val userName: Optional[UserNameType] = zio.aws.core.internal
      .optionalFromNullable(impl.userName())
      .map(value => zio.aws.iam.model.primitives.UserNameType(value))
    override val accessKeyId: Optional[AccessKeyIdType] = zio.aws.core.internal
      .optionalFromNullable(impl.accessKeyId())
      .map(value => zio.aws.iam.model.primitives.AccessKeyIdType(value))
    override val status: Optional[zio.aws.iam.model.StatusType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.iam.model.StatusType.wrap(value))
    override val createDate: Optional[DateType] = zio.aws.core.internal
      .optionalFromNullable(impl.createDate())
      .map(value => zio.aws.iam.model.primitives.DateType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iam.model.AccessKeyMetadata
  ): zio.aws.iam.model.AccessKeyMetadata.ReadOnly = new Wrapper(impl)
}
