package zio.aws.iam.model
import scala.jdk.CollectionConverters.*
sealed trait AssignmentStatusType {
  def unwrap: software.amazon.awssdk.services.iam.model.AssignmentStatusType
}
object AssignmentStatusType {
  def wrap(
      value: software.amazon.awssdk.services.iam.model.AssignmentStatusType
  ): zio.aws.iam.model.AssignmentStatusType = value match {
    case software.amazon.awssdk.services.iam.model.AssignmentStatusType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.iam.model.AssignmentStatusType.ASSIGNED =>
      val r = Assigned
      r
    case software.amazon.awssdk.services.iam.model.AssignmentStatusType.UNASSIGNED =>
      val r = Unassigned
      r
    case software.amazon.awssdk.services.iam.model.AssignmentStatusType.ANY =>
      val r = Any
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.iam.model.AssignmentStatusType {
    override def unwrap
        : software.amazon.awssdk.services.iam.model.AssignmentStatusType =
      software.amazon.awssdk.services.iam.model.AssignmentStatusType.UNKNOWN_TO_SDK_VERSION
  }
  case object Assigned extends zio.aws.iam.model.AssignmentStatusType {
    override def unwrap
        : software.amazon.awssdk.services.iam.model.AssignmentStatusType =
      software.amazon.awssdk.services.iam.model.AssignmentStatusType.ASSIGNED
  }
  case object Unassigned extends zio.aws.iam.model.AssignmentStatusType {
    override def unwrap
        : software.amazon.awssdk.services.iam.model.AssignmentStatusType =
      software.amazon.awssdk.services.iam.model.AssignmentStatusType.UNASSIGNED
  }
  case object Any extends zio.aws.iam.model.AssignmentStatusType {
    override def unwrap
        : software.amazon.awssdk.services.iam.model.AssignmentStatusType =
      software.amazon.awssdk.services.iam.model.AssignmentStatusType.ANY
  }
}
