package zio.aws.iam.model
import zio.aws.iam.model.primitives.{ArnType, GroupNameType}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class AttachGroupPolicyRequest(
    groupName: GroupNameType,
    policyArn: ArnType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iam.model.AttachGroupPolicyRequest = {
    import AttachGroupPolicyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iam.model.AttachGroupPolicyRequest
      .builder()
      .groupName(GroupNameType.unwrap(groupName): java.lang.String)
      .policyArn(ArnType.unwrap(policyArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.iam.model.AttachGroupPolicyRequest.ReadOnly =
    zio.aws.iam.model.AttachGroupPolicyRequest.wrap(buildAwsValue())
}
object AttachGroupPolicyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iam.model.AttachGroupPolicyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iam.model.AttachGroupPolicyRequest =
      zio.aws.iam.model.AttachGroupPolicyRequest(groupName, policyArn)
    def groupName: GroupNameType
    def policyArn: ArnType
    def getGroupName: ZIO[Any, Nothing, GroupNameType] = ZIO.succeed(groupName)
    def getPolicyArn: ZIO[Any, Nothing, ArnType] = ZIO.succeed(policyArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iam.model.AttachGroupPolicyRequest
  ) extends zio.aws.iam.model.AttachGroupPolicyRequest.ReadOnly {
    override val groupName: GroupNameType =
      zio.aws.iam.model.primitives.GroupNameType(impl.groupName())
    override val policyArn: ArnType =
      zio.aws.iam.model.primitives.ArnType(impl.policyArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iam.model.AttachGroupPolicyRequest
  ): zio.aws.iam.model.AttachGroupPolicyRequest.ReadOnly = new Wrapper(impl)
}
