package zio.aws.iam.model
import zio.aws.iam.model.primitives.{ArnType, RoleNameType}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class AttachRolePolicyRequest(
    roleName: RoleNameType,
    policyArn: ArnType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iam.model.AttachRolePolicyRequest = {
    import AttachRolePolicyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iam.model.AttachRolePolicyRequest
      .builder()
      .roleName(RoleNameType.unwrap(roleName): java.lang.String)
      .policyArn(ArnType.unwrap(policyArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.iam.model.AttachRolePolicyRequest.ReadOnly =
    zio.aws.iam.model.AttachRolePolicyRequest.wrap(buildAwsValue())
}
object AttachRolePolicyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iam.model.AttachRolePolicyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iam.model.AttachRolePolicyRequest =
      zio.aws.iam.model.AttachRolePolicyRequest(roleName, policyArn)
    def roleName: RoleNameType
    def policyArn: ArnType
    def getRoleName: ZIO[Any, Nothing, RoleNameType] = ZIO.succeed(roleName)
    def getPolicyArn: ZIO[Any, Nothing, ArnType] = ZIO.succeed(policyArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iam.model.AttachRolePolicyRequest
  ) extends zio.aws.iam.model.AttachRolePolicyRequest.ReadOnly {
    override val roleName: RoleNameType =
      zio.aws.iam.model.primitives.RoleNameType(impl.roleName())
    override val policyArn: ArnType =
      zio.aws.iam.model.primitives.ArnType(impl.policyArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iam.model.AttachRolePolicyRequest
  ): zio.aws.iam.model.AttachRolePolicyRequest.ReadOnly = new Wrapper(impl)
}
