package zio.aws.iam.model
import zio.aws.iam.model.primitives.{ArnType, UserNameType}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class AttachUserPolicyRequest(
    userName: UserNameType,
    policyArn: ArnType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iam.model.AttachUserPolicyRequest = {
    import AttachUserPolicyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iam.model.AttachUserPolicyRequest
      .builder()
      .userName(UserNameType.unwrap(userName): java.lang.String)
      .policyArn(ArnType.unwrap(policyArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.iam.model.AttachUserPolicyRequest.ReadOnly =
    zio.aws.iam.model.AttachUserPolicyRequest.wrap(buildAwsValue())
}
object AttachUserPolicyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iam.model.AttachUserPolicyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iam.model.AttachUserPolicyRequest =
      zio.aws.iam.model.AttachUserPolicyRequest(userName, policyArn)
    def userName: UserNameType
    def policyArn: ArnType
    def getUserName: ZIO[Any, Nothing, UserNameType] = ZIO.succeed(userName)
    def getPolicyArn: ZIO[Any, Nothing, ArnType] = ZIO.succeed(policyArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iam.model.AttachUserPolicyRequest
  ) extends zio.aws.iam.model.AttachUserPolicyRequest.ReadOnly {
    override val userName: UserNameType =
      zio.aws.iam.model.primitives.UserNameType(impl.userName())
    override val policyArn: ArnType =
      zio.aws.iam.model.primitives.ArnType(impl.policyArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iam.model.AttachUserPolicyRequest
  ): zio.aws.iam.model.AttachUserPolicyRequest.ReadOnly = new Wrapper(impl)
}
