package zio.aws.iam.model
import zio.aws.iam.model.primitives.PasswordType
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class ChangePasswordRequest(
    oldPassword: PasswordType,
    newPassword: PasswordType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iam.model.ChangePasswordRequest = {
    import ChangePasswordRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iam.model.ChangePasswordRequest
      .builder()
      .oldPassword(PasswordType.unwrap(oldPassword): java.lang.String)
      .newPassword(PasswordType.unwrap(newPassword): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.iam.model.ChangePasswordRequest.ReadOnly =
    zio.aws.iam.model.ChangePasswordRequest.wrap(buildAwsValue())
}
object ChangePasswordRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iam.model.ChangePasswordRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iam.model.ChangePasswordRequest =
      zio.aws.iam.model.ChangePasswordRequest(oldPassword, newPassword)
    def oldPassword: PasswordType
    def newPassword: PasswordType
    def getOldPassword: ZIO[Any, Nothing, PasswordType] =
      ZIO.succeed(oldPassword)
    def getNewPassword: ZIO[Any, Nothing, PasswordType] =
      ZIO.succeed(newPassword)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iam.model.ChangePasswordRequest
  ) extends zio.aws.iam.model.ChangePasswordRequest.ReadOnly {
    override val oldPassword: PasswordType =
      zio.aws.iam.model.primitives.PasswordType(impl.oldPassword())
    override val newPassword: PasswordType =
      zio.aws.iam.model.primitives.PasswordType(impl.newPassword())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iam.model.ChangePasswordRequest
  ): zio.aws.iam.model.ChangePasswordRequest.ReadOnly = new Wrapper(impl)
}
