package zio.aws.iam.model
import zio.aws.iam.model.primitives.AccountAliasType
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class CreateAccountAliasRequest(accountAlias: AccountAliasType) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iam.model.CreateAccountAliasRequest = {
    import CreateAccountAliasRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iam.model.CreateAccountAliasRequest
      .builder()
      .accountAlias(AccountAliasType.unwrap(accountAlias): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.iam.model.CreateAccountAliasRequest.ReadOnly =
    zio.aws.iam.model.CreateAccountAliasRequest.wrap(buildAwsValue())
}
object CreateAccountAliasRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iam.model.CreateAccountAliasRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iam.model.CreateAccountAliasRequest =
      zio.aws.iam.model.CreateAccountAliasRequest(accountAlias)
    def accountAlias: AccountAliasType
    def getAccountAlias: ZIO[Any, Nothing, AccountAliasType] =
      ZIO.succeed(accountAlias)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iam.model.CreateAccountAliasRequest
  ) extends zio.aws.iam.model.CreateAccountAliasRequest.ReadOnly {
    override val accountAlias: AccountAliasType =
      zio.aws.iam.model.primitives.AccountAliasType(impl.accountAlias())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iam.model.CreateAccountAliasRequest
  ): zio.aws.iam.model.CreateAccountAliasRequest.ReadOnly = new Wrapper(impl)
}
