package zio.aws.iam.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class CreateGroupResponse(group: zio.aws.iam.model.Group) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iam.model.CreateGroupResponse = {
    import CreateGroupResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iam.model.CreateGroupResponse
      .builder()
      .group(group.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.iam.model.CreateGroupResponse.ReadOnly =
    zio.aws.iam.model.CreateGroupResponse.wrap(buildAwsValue())
}
object CreateGroupResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iam.model.CreateGroupResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iam.model.CreateGroupResponse =
      zio.aws.iam.model.CreateGroupResponse(group.asEditable)
    def group: zio.aws.iam.model.Group.ReadOnly
    def getGroup: ZIO[Any, Nothing, zio.aws.iam.model.Group.ReadOnly] =
      ZIO.succeed(group)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iam.model.CreateGroupResponse
  ) extends zio.aws.iam.model.CreateGroupResponse.ReadOnly {
    override val group: zio.aws.iam.model.Group.ReadOnly =
      zio.aws.iam.model.Group.wrap(impl.group())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iam.model.CreateGroupResponse
  ): zio.aws.iam.model.CreateGroupResponse.ReadOnly = new Wrapper(impl)
}
