package zio.aws.iam.model
import zio.aws.iam.model.primitives.{BooleanType, PasswordType, UserNameType}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateLoginProfileRequest(
    userName: UserNameType,
    password: PasswordType,
    passwordResetRequired: Optional[BooleanType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iam.model.CreateLoginProfileRequest = {
    import CreateLoginProfileRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iam.model.CreateLoginProfileRequest
      .builder()
      .userName(UserNameType.unwrap(userName): java.lang.String)
      .password(PasswordType.unwrap(password): java.lang.String)
      .optionallyWith(
        passwordResetRequired.map(value =>
          BooleanType.unwrap(value): java.lang.Boolean
        )
      )(_.passwordResetRequired)
      .build()
  }
  def asReadOnly: zio.aws.iam.model.CreateLoginProfileRequest.ReadOnly =
    zio.aws.iam.model.CreateLoginProfileRequest.wrap(buildAwsValue())
}
object CreateLoginProfileRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iam.model.CreateLoginProfileRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iam.model.CreateLoginProfileRequest =
      zio.aws.iam.model.CreateLoginProfileRequest(
        userName,
        password,
        passwordResetRequired.map(value => value)
      )
    def userName: UserNameType
    def password: PasswordType
    def passwordResetRequired: Optional[BooleanType]
    def getUserName: ZIO[Any, Nothing, UserNameType] = ZIO.succeed(userName)
    def getPassword: ZIO[Any, Nothing, PasswordType] = ZIO.succeed(password)
    def getPasswordResetRequired: ZIO[Any, AwsError, BooleanType] =
      AwsError.unwrapOptionField("passwordResetRequired", passwordResetRequired)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iam.model.CreateLoginProfileRequest
  ) extends zio.aws.iam.model.CreateLoginProfileRequest.ReadOnly {
    override val userName: UserNameType =
      zio.aws.iam.model.primitives.UserNameType(impl.userName())
    override val password: PasswordType =
      zio.aws.iam.model.primitives.PasswordType(impl.password())
    override val passwordResetRequired: Optional[BooleanType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.passwordResetRequired())
        .map(value => zio.aws.iam.model.primitives.BooleanType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iam.model.CreateLoginProfileRequest
  ): zio.aws.iam.model.CreateLoginProfileRequest.ReadOnly = new Wrapper(impl)
}
