package zio.aws.iam.model
import zio.aws.iam.model.primitives.{BooleanType, PolicyDocumentType, ArnType}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreatePolicyVersionRequest(
    policyArn: ArnType,
    policyDocument: PolicyDocumentType,
    setAsDefault: Optional[BooleanType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iam.model.CreatePolicyVersionRequest = {
    import CreatePolicyVersionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iam.model.CreatePolicyVersionRequest
      .builder()
      .policyArn(ArnType.unwrap(policyArn): java.lang.String)
      .policyDocument(
        PolicyDocumentType.unwrap(policyDocument): java.lang.String
      )
      .optionallyWith(
        setAsDefault.map(value => BooleanType.unwrap(value): java.lang.Boolean)
      )(_.setAsDefault)
      .build()
  }
  def asReadOnly: zio.aws.iam.model.CreatePolicyVersionRequest.ReadOnly =
    zio.aws.iam.model.CreatePolicyVersionRequest.wrap(buildAwsValue())
}
object CreatePolicyVersionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iam.model.CreatePolicyVersionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iam.model.CreatePolicyVersionRequest =
      zio.aws.iam.model.CreatePolicyVersionRequest(
        policyArn,
        policyDocument,
        setAsDefault.map(value => value)
      )
    def policyArn: ArnType
    def policyDocument: PolicyDocumentType
    def setAsDefault: Optional[BooleanType]
    def getPolicyArn: ZIO[Any, Nothing, ArnType] = ZIO.succeed(policyArn)
    def getPolicyDocument: ZIO[Any, Nothing, PolicyDocumentType] =
      ZIO.succeed(policyDocument)
    def getSetAsDefault: ZIO[Any, AwsError, BooleanType] =
      AwsError.unwrapOptionField("setAsDefault", setAsDefault)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iam.model.CreatePolicyVersionRequest
  ) extends zio.aws.iam.model.CreatePolicyVersionRequest.ReadOnly {
    override val policyArn: ArnType =
      zio.aws.iam.model.primitives.ArnType(impl.policyArn())
    override val policyDocument: PolicyDocumentType =
      zio.aws.iam.model.primitives.PolicyDocumentType(impl.policyDocument())
    override val setAsDefault: Optional[BooleanType] = zio.aws.core.internal
      .optionalFromNullable(impl.setAsDefault())
      .map(value => zio.aws.iam.model.primitives.BooleanType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iam.model.CreatePolicyVersionRequest
  ): zio.aws.iam.model.CreatePolicyVersionRequest.ReadOnly = new Wrapper(impl)
}
