package zio.aws.iam.model
import zio.aws.iam.model.primitives.{VirtualMFADeviceName, PathType}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateVirtualMfaDeviceRequest(
    path: Optional[PathType] = Optional.Absent,
    virtualMFADeviceName: VirtualMFADeviceName,
    tags: Optional[Iterable[zio.aws.iam.model.Tag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iam.model.CreateVirtualMfaDeviceRequest = {
    import CreateVirtualMfaDeviceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iam.model.CreateVirtualMfaDeviceRequest
      .builder()
      .optionallyWith(
        path.map(value => PathType.unwrap(value): java.lang.String)
      )(_.path)
      .virtualMFADeviceName(
        VirtualMFADeviceName.unwrap(virtualMFADeviceName): java.lang.String
      )
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.iam.model.CreateVirtualMfaDeviceRequest.ReadOnly =
    zio.aws.iam.model.CreateVirtualMfaDeviceRequest.wrap(buildAwsValue())
}
object CreateVirtualMfaDeviceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iam.model.CreateVirtualMfaDeviceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iam.model.CreateVirtualMfaDeviceRequest =
      zio.aws.iam.model.CreateVirtualMfaDeviceRequest(
        path.map(value => value),
        virtualMFADeviceName,
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def path: Optional[PathType]
    def virtualMFADeviceName: VirtualMFADeviceName
    def tags: Optional[List[zio.aws.iam.model.Tag.ReadOnly]]
    def getPath: ZIO[Any, AwsError, PathType] =
      AwsError.unwrapOptionField("path", path)
    def getVirtualMFADeviceName: ZIO[Any, Nothing, VirtualMFADeviceName] =
      ZIO.succeed(virtualMFADeviceName)
    def getTags: ZIO[Any, AwsError, List[zio.aws.iam.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iam.model.CreateVirtualMfaDeviceRequest
  ) extends zio.aws.iam.model.CreateVirtualMfaDeviceRequest.ReadOnly {
    override val path: Optional[PathType] = zio.aws.core.internal
      .optionalFromNullable(impl.path())
      .map(value => zio.aws.iam.model.primitives.PathType(value))
    override val virtualMFADeviceName: VirtualMFADeviceName =
      zio.aws.iam.model.primitives
        .VirtualMFADeviceName(impl.virtualMFADeviceName())
    override val tags: Optional[List[zio.aws.iam.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.iam.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iam.model.CreateVirtualMfaDeviceRequest
  ): zio.aws.iam.model.CreateVirtualMfaDeviceRequest.ReadOnly = new Wrapper(
    impl
  )
}
