package zio.aws.iam.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class CreateVirtualMfaDeviceResponse(
    virtualMFADevice: zio.aws.iam.model.VirtualMFADevice
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iam.model.CreateVirtualMfaDeviceResponse = {
    import CreateVirtualMfaDeviceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iam.model.CreateVirtualMfaDeviceResponse
      .builder()
      .virtualMFADevice(virtualMFADevice.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.iam.model.CreateVirtualMfaDeviceResponse.ReadOnly =
    zio.aws.iam.model.CreateVirtualMfaDeviceResponse.wrap(buildAwsValue())
}
object CreateVirtualMfaDeviceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iam.model.CreateVirtualMfaDeviceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iam.model.CreateVirtualMfaDeviceResponse =
      zio.aws.iam.model
        .CreateVirtualMfaDeviceResponse(virtualMFADevice.asEditable)
    def virtualMFADevice: zio.aws.iam.model.VirtualMFADevice.ReadOnly
    def getVirtualMFADevice
        : ZIO[Any, Nothing, zio.aws.iam.model.VirtualMFADevice.ReadOnly] =
      ZIO.succeed(virtualMFADevice)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iam.model.CreateVirtualMfaDeviceResponse
  ) extends zio.aws.iam.model.CreateVirtualMfaDeviceResponse.ReadOnly {
    override val virtualMFADevice: zio.aws.iam.model.VirtualMFADevice.ReadOnly =
      zio.aws.iam.model.VirtualMFADevice.wrap(impl.virtualMFADevice())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iam.model.CreateVirtualMfaDeviceResponse
  ): zio.aws.iam.model.CreateVirtualMfaDeviceResponse.ReadOnly = new Wrapper(
    impl
  )
}
