package zio.aws.iam.model
import zio.aws.iam.model.primitives.InstanceProfileNameType
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DeleteInstanceProfileRequest(
    instanceProfileName: InstanceProfileNameType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iam.model.DeleteInstanceProfileRequest = {
    import DeleteInstanceProfileRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iam.model.DeleteInstanceProfileRequest
      .builder()
      .instanceProfileName(
        InstanceProfileNameType.unwrap(instanceProfileName): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.iam.model.DeleteInstanceProfileRequest.ReadOnly =
    zio.aws.iam.model.DeleteInstanceProfileRequest.wrap(buildAwsValue())
}
object DeleteInstanceProfileRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iam.model.DeleteInstanceProfileRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iam.model.DeleteInstanceProfileRequest =
      zio.aws.iam.model.DeleteInstanceProfileRequest(instanceProfileName)
    def instanceProfileName: InstanceProfileNameType
    def getInstanceProfileName: ZIO[Any, Nothing, InstanceProfileNameType] =
      ZIO.succeed(instanceProfileName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iam.model.DeleteInstanceProfileRequest
  ) extends zio.aws.iam.model.DeleteInstanceProfileRequest.ReadOnly {
    override val instanceProfileName: InstanceProfileNameType =
      zio.aws.iam.model.primitives
        .InstanceProfileNameType(impl.instanceProfileName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iam.model.DeleteInstanceProfileRequest
  ): zio.aws.iam.model.DeleteInstanceProfileRequest.ReadOnly = new Wrapper(impl)
}
